// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
//
// End prologue.

#include <cassert>

namespace cli
{
  // usage_para
  //
  inline usage_para::
  usage_para (value v)
  : v_ (v)
  {
  }

  // unknown_mode
  //
  inline unknown_mode::
  unknown_mode (value v)
  : v_ (v)
  {
  }

  // exception
  //
  inline ::std::ostream&
  operator<< (::std::ostream& os, const exception& e)
  {
    e.print (os);
    return os;
  }

  // unknown_option
  //
  inline unknown_option::
  unknown_option (const std::string& option)
  : option_ (option)
  {
  }

  inline const std::string& unknown_option::
  option () const
  {
    return option_;
  }

  // unknown_argument
  //
  inline unknown_argument::
  unknown_argument (const std::string& argument)
  : argument_ (argument)
  {
  }

  inline const std::string& unknown_argument::
  argument () const
  {
    return argument_;
  }

  // missing_value
  //
  inline missing_value::
  missing_value (const std::string& option)
  : option_ (option)
  {
  }

  inline const std::string& missing_value::
  option () const
  {
    return option_;
  }

  // invalid_value
  //
  inline invalid_value::
  invalid_value (const std::string& option,
                 const std::string& value,
                 const std::string& message)
  : option_ (option),
    value_ (value),
    message_ (message)
  {
  }

  inline const std::string& invalid_value::
  option () const
  {
    return option_;
  }

  inline const std::string& invalid_value::
  value () const
  {
    return value_;
  }

  inline const std::string& invalid_value::
  message () const
  {
    return message_;
  }

  // file_io_failure
  //
  inline file_io_failure::
  file_io_failure (const std::string& file)
  : file_ (file)
  {
  }

  inline const std::string& file_io_failure::
  file () const
  {
    return file_;
  }

  // unmatched_quote
  //
  inline unmatched_quote::
  unmatched_quote (const std::string& argument)
  : argument_ (argument)
  {
  }

  inline const std::string& unmatched_quote::
  argument () const
  {
    return argument_;
  }

  // argv_scanner
  //
  inline argv_scanner::
  argv_scanner (int& argc,
                char** argv,
                bool erase,
                std::size_t sp)
  : start_position_ (sp + 1),
    i_ (1),
    argc_ (argc),
    argv_ (argv),
    erase_ (erase)
  {
  }

  inline argv_scanner::
  argv_scanner (int start,
                int& argc,
                char** argv,
                bool erase,
                std::size_t sp)
  : start_position_ (sp + static_cast<std::size_t> (start)),
    i_ (start),
    argc_ (argc),
    argv_ (argv),
    erase_ (erase)
  {
  }

  inline int argv_scanner::
  end () const
  {
    return i_;
  }

  // argv_file_scanner
  //
  inline argv_file_scanner::
  argv_file_scanner (int& argc,
                     char** argv,
                     const std::string& option,
                     bool erase,
                     std::size_t sp)
  : argv_scanner (argc, argv, erase, sp),
    option_ (option),
    options_ (&option_info_),
    options_count_ (1),
    i_ (1),
    skip_ (false)
  {
    option_info_.option = option_.c_str ();
    option_info_.search_func = 0;
  }

  inline argv_file_scanner::
  argv_file_scanner (int start,
                     int& argc,
                     char** argv,
                     const std::string& option,
                     bool erase,
                     std::size_t sp)
  : argv_scanner (start, argc, argv, erase, sp),
    option_ (option),
    options_ (&option_info_),
    options_count_ (1),
    i_ (1),
    skip_ (false)
  {
    option_info_.option = option_.c_str ();
    option_info_.search_func = 0;
  }

  inline argv_file_scanner::
  argv_file_scanner (const std::string& file,
                     const std::string& option,
                     std::size_t sp)
  : argv_scanner (0, zero_argc_, 0, sp),
    option_ (option),
    options_ (&option_info_),
    options_count_ (1),
    i_ (1),
    skip_ (false)
  {
    option_info_.option = option_.c_str ();
    option_info_.search_func = 0;

    load (file);
  }

  inline argv_file_scanner::
  argv_file_scanner (int& argc,
                     char** argv,
                     const option_info* options,
                     std::size_t options_count,
                     bool erase,
                     std::size_t sp)
  : argv_scanner (argc, argv, erase, sp),
    options_ (options),
    options_count_ (options_count),
    i_ (1),
    skip_ (false)
  {
  }

  inline argv_file_scanner::
  argv_file_scanner (int start,
                     int& argc,
                     char** argv,
                     const option_info* options,
                     std::size_t options_count,
                     bool erase,
                     std::size_t sp)
  : argv_scanner (start, argc, argv, erase, sp),
    options_ (options),
    options_count_ (options_count),
    i_ (1),
    skip_ (false)
  {
  }

  inline argv_file_scanner::
  argv_file_scanner (const std::string& file,
                     const option_info* options,
                     std::size_t options_count,
                     std::size_t sp)
  : argv_scanner (0, zero_argc_, 0, sp),
    options_ (options),
    options_count_ (options_count),
    i_ (1),
    skip_ (false)
  {
    load (file);
  }

  inline const std::string& option::
  name () const
  {
    return name_;
  }

  inline const option_names& option::
  aliases () const
  {
    return aliases_;
  }

  inline bool option::
  flag () const
  {
    return flag_;
  }

  inline const std::string& option::
  default_value () const
  {
    return default_value_;
  }

  inline option::
  option ()
  {
  }

  inline option::
  option (const std::string& n,
          const option_names& a,
          bool f,
          const std::string& dv)
  : name_ (n), aliases_ (a), flag_ (f), default_value_ (dv)
  {
  }

  inline options::container_type::const_iterator options::
  find (const std::string& name) const
  {
    map_type::const_iterator i (map_.find (name));
    return i != map_.end () ? begin () + i->second : end ();
  }
}

// options
//

inline const std::uint64_t& options::
build2_metadata () const
{
  return this->build2_metadata_;
}

inline std::uint64_t& options::
build2_metadata ()
{
  return this->build2_metadata_;
}

inline void options::
build2_metadata (const std::uint64_t& x)
{
  this->build2_metadata_ = x;
}

inline bool options::
build2_metadata_specified () const
{
  return this->build2_metadata_specified_;
}

inline void options::
build2_metadata_specified (bool x)
{
  this->build2_metadata_specified_ = x;
}

inline const bool& options::
help () const
{
  return this->help_;
}

inline bool& options::
help ()
{
  return this->help_;
}

inline void options::
help (const bool& x)
{
  this->help_ = x;
}

inline const bool& options::
version () const
{
  return this->version_;
}

inline bool& options::
version ()
{
  return this->version_;
}

inline void options::
version (const bool& x)
{
  this->version_ = x;
}

inline const std::vector<std::string>& options::
I () const
{
  return this->I_;
}

inline std::vector<std::string>& options::
I ()
{
  return this->I_;
}

inline void options::
I (const std::vector<std::string>& x)
{
  this->I_ = x;
}

inline bool options::
I_specified () const
{
  return this->I_specified_;
}

inline void options::
I_specified (bool x)
{
  this->I_specified_ = x;
}

inline const std::vector<std::string>& options::
D () const
{
  return this->D_;
}

inline std::vector<std::string>& options::
D ()
{
  return this->D_;
}

inline void options::
D (const std::vector<std::string>& x)
{
  this->D_ = x;
}

inline bool options::
D_specified () const
{
  return this->D_specified_;
}

inline void options::
D_specified (bool x)
{
  this->D_specified_ = x;
}

inline const std::vector<std::string>& options::
U () const
{
  return this->U_;
}

inline std::vector<std::string>& options::
U ()
{
  return this->U_;
}

inline void options::
U (const std::vector<std::string>& x)
{
  this->U_ = x;
}

inline bool options::
U_specified () const
{
  return this->U_specified_;
}

inline void options::
U_specified (bool x)
{
  this->U_specified_ = x;
}

inline const std::vector< ::database>& options::
database () const
{
  return this->database_;
}

inline std::vector< ::database>& options::
database ()
{
  return this->database_;
}

inline void options::
database (const std::vector< ::database>& x)
{
  this->database_ = x;
}

inline bool options::
database_specified () const
{
  return this->database_specified_;
}

inline void options::
database_specified (bool x)
{
  this->database_specified_ = x;
}

inline const ::multi_database& options::
multi_database () const
{
  return this->multi_database_;
}

inline ::multi_database& options::
multi_database ()
{
  return this->multi_database_;
}

inline void options::
multi_database (const ::multi_database& x)
{
  this->multi_database_ = x;
}

inline bool options::
multi_database_specified () const
{
  return this->multi_database_specified_;
}

inline void options::
multi_database_specified (bool x)
{
  this->multi_database_specified_ = x;
}

inline const ::database& options::
default_database () const
{
  return this->default_database_;
}

inline ::database& options::
default_database ()
{
  return this->default_database_;
}

inline void options::
default_database (const ::database& x)
{
  this->default_database_ = x;
}

inline bool options::
default_database_specified () const
{
  return this->default_database_specified_;
}

inline void options::
default_database_specified (bool x)
{
  this->default_database_specified_ = x;
}

inline const bool& options::
generate_query () const
{
  return this->generate_query_;
}

inline bool& options::
generate_query ()
{
  return this->generate_query_;
}

inline void options::
generate_query (const bool& x)
{
  this->generate_query_ = x;
}

inline const bool& options::
generate_prepared () const
{
  return this->generate_prepared_;
}

inline bool& options::
generate_prepared ()
{
  return this->generate_prepared_;
}

inline void options::
generate_prepared (const bool& x)
{
  this->generate_prepared_ = x;
}

inline const bool& options::
omit_unprepared () const
{
  return this->omit_unprepared_;
}

inline bool& options::
omit_unprepared ()
{
  return this->omit_unprepared_;
}

inline void options::
omit_unprepared (const bool& x)
{
  this->omit_unprepared_ = x;
}

inline const bool& options::
generate_session () const
{
  return this->generate_session_;
}

inline bool& options::
generate_session ()
{
  return this->generate_session_;
}

inline void options::
generate_session (const bool& x)
{
  this->generate_session_ = x;
}

inline const bool& options::
generate_schema () const
{
  return this->generate_schema_;
}

inline bool& options::
generate_schema ()
{
  return this->generate_schema_;
}

inline void options::
generate_schema (const bool& x)
{
  this->generate_schema_ = x;
}

inline const bool& options::
generate_schema_only () const
{
  return this->generate_schema_only_;
}

inline bool& options::
generate_schema_only ()
{
  return this->generate_schema_only_;
}

inline void options::
generate_schema_only (const bool& x)
{
  this->generate_schema_only_ = x;
}

inline const bool& options::
suppress_migration () const
{
  return this->suppress_migration_;
}

inline bool& options::
suppress_migration ()
{
  return this->suppress_migration_;
}

inline void options::
suppress_migration (const bool& x)
{
  this->suppress_migration_ = x;
}

inline const bool& options::
suppress_schema_version () const
{
  return this->suppress_schema_version_;
}

inline bool& options::
suppress_schema_version ()
{
  return this->suppress_schema_version_;
}

inline void options::
suppress_schema_version (const bool& x)
{
  this->suppress_schema_version_ = x;
}

inline const database_map<qname>& options::
schema_version_table () const
{
  return this->schema_version_table_;
}

inline database_map<qname>& options::
schema_version_table ()
{
  return this->schema_version_table_;
}

inline void options::
schema_version_table (const database_map<qname>& x)
{
  this->schema_version_table_ = x;
}

inline bool options::
schema_version_table_specified () const
{
  return this->schema_version_table_specified_;
}

inline void options::
schema_version_table_specified (bool x)
{
  this->schema_version_table_specified_ = x;
}

inline const database_map<std::set< ::schema_format> >& options::
schema_format () const
{
  return this->schema_format_;
}

inline database_map<std::set< ::schema_format> >& options::
schema_format ()
{
  return this->schema_format_;
}

inline void options::
schema_format (const database_map<std::set< ::schema_format> >& x)
{
  this->schema_format_ = x;
}

inline bool options::
schema_format_specified () const
{
  return this->schema_format_specified_;
}

inline void options::
schema_format_specified (bool x)
{
  this->schema_format_specified_ = x;
}

inline const bool& options::
omit_drop () const
{
  return this->omit_drop_;
}

inline bool& options::
omit_drop ()
{
  return this->omit_drop_;
}

inline void options::
omit_drop (const bool& x)
{
  this->omit_drop_ = x;
}

inline const bool& options::
omit_create () const
{
  return this->omit_create_;
}

inline bool& options::
omit_create ()
{
  return this->omit_create_;
}

inline void options::
omit_create (const bool& x)
{
  this->omit_create_ = x;
}

inline const database_map<std::string>& options::
schema_name () const
{
  return this->schema_name_;
}

inline database_map<std::string>& options::
schema_name ()
{
  return this->schema_name_;
}

inline void options::
schema_name (const database_map<std::string>& x)
{
  this->schema_name_ = x;
}

inline bool options::
schema_name_specified () const
{
  return this->schema_name_specified_;
}

inline void options::
schema_name_specified (bool x)
{
  this->schema_name_specified_ = x;
}

inline const database_map<deferrable>& options::
fkeys_deferrable_mode () const
{
  return this->fkeys_deferrable_mode_;
}

inline database_map<deferrable>& options::
fkeys_deferrable_mode ()
{
  return this->fkeys_deferrable_mode_;
}

inline void options::
fkeys_deferrable_mode (const database_map<deferrable>& x)
{
  this->fkeys_deferrable_mode_ = x;
}

inline bool options::
fkeys_deferrable_mode_specified () const
{
  return this->fkeys_deferrable_mode_specified_;
}

inline void options::
fkeys_deferrable_mode_specified (bool x)
{
  this->fkeys_deferrable_mode_specified_ = x;
}

inline const std::string& options::
default_pointer () const
{
  return this->default_pointer_;
}

inline std::string& options::
default_pointer ()
{
  return this->default_pointer_;
}

inline void options::
default_pointer (const std::string& x)
{
  this->default_pointer_ = x;
}

inline bool options::
default_pointer_specified () const
{
  return this->default_pointer_specified_;
}

inline void options::
default_pointer_specified (bool x)
{
  this->default_pointer_specified_ = x;
}

inline const std::string& options::
session_type () const
{
  return this->session_type_;
}

inline std::string& options::
session_type ()
{
  return this->session_type_;
}

inline void options::
session_type (const std::string& x)
{
  this->session_type_ = x;
}

inline bool options::
session_type_specified () const
{
  return this->session_type_specified_;
}

inline void options::
session_type_specified (bool x)
{
  this->session_type_specified_ = x;
}

inline const std::string& options::
profile () const
{
  return this->profile_;
}

inline std::string& options::
profile ()
{
  return this->profile_;
}

inline void options::
profile (const std::string& x)
{
  this->profile_ = x;
}

inline bool options::
profile_specified () const
{
  return this->profile_specified_;
}

inline void options::
profile_specified (bool x)
{
  this->profile_specified_ = x;
}

inline const bool& options::
at_once () const
{
  return this->at_once_;
}

inline bool& options::
at_once ()
{
  return this->at_once_;
}

inline void options::
at_once (const bool& x)
{
  this->at_once_ = x;
}

inline const database_map<qname>& options::
schema () const
{
  return this->schema_;
}

inline database_map<qname>& options::
schema ()
{
  return this->schema_;
}

inline void options::
schema (const database_map<qname>& x)
{
  this->schema_ = x;
}

inline bool options::
schema_specified () const
{
  return this->schema_specified_;
}

inline void options::
schema_specified (bool x)
{
  this->schema_specified_ = x;
}

inline const database_map<std::string>& options::
export_symbol () const
{
  return this->export_symbol_;
}

inline database_map<std::string>& options::
export_symbol ()
{
  return this->export_symbol_;
}

inline void options::
export_symbol (const database_map<std::string>& x)
{
  this->export_symbol_ = x;
}

inline bool options::
export_symbol_specified () const
{
  return this->export_symbol_specified_;
}

inline void options::
export_symbol_specified (bool x)
{
  this->export_symbol_specified_ = x;
}

inline const database_map<std::string>& options::
extern_symbol () const
{
  return this->extern_symbol_;
}

inline database_map<std::string>& options::
extern_symbol ()
{
  return this->extern_symbol_;
}

inline void options::
extern_symbol (const database_map<std::string>& x)
{
  this->extern_symbol_ = x;
}

inline bool options::
extern_symbol_specified () const
{
  return this->extern_symbol_specified_;
}

inline void options::
extern_symbol_specified (bool x)
{
  this->extern_symbol_specified_ = x;
}

inline const cxx_version& options::
std () const
{
  return this->std_;
}

inline cxx_version& options::
std ()
{
  return this->std_;
}

inline void options::
std (const cxx_version& x)
{
  this->std_ = x;
}

inline bool options::
std_specified () const
{
  return this->std_specified_;
}

inline void options::
std_specified (bool x)
{
  this->std_specified_ = x;
}

inline const bool& options::
warn_hard_add () const
{
  return this->warn_hard_add_;
}

inline bool& options::
warn_hard_add ()
{
  return this->warn_hard_add_;
}

inline void options::
warn_hard_add (const bool& x)
{
  this->warn_hard_add_ = x;
}

inline const bool& options::
warn_hard_delete () const
{
  return this->warn_hard_delete_;
}

inline bool& options::
warn_hard_delete ()
{
  return this->warn_hard_delete_;
}

inline void options::
warn_hard_delete (const bool& x)
{
  this->warn_hard_delete_ = x;
}

inline const bool& options::
warn_hard () const
{
  return this->warn_hard_;
}

inline bool& options::
warn_hard ()
{
  return this->warn_hard_;
}

inline void options::
warn_hard (const bool& x)
{
  this->warn_hard_ = x;
}

inline const bool& options::
warn_unspecified_load () const
{
  return this->warn_unspecified_load_;
}

inline bool& options::
warn_unspecified_load ()
{
  return this->warn_unspecified_load_;
}

inline void options::
warn_unspecified_load (const bool& x)
{
  this->warn_unspecified_load_ = x;
}

inline const std::string& options::
output_dir () const
{
  return this->output_dir_;
}

inline std::string& options::
output_dir ()
{
  return this->output_dir_;
}

inline void options::
output_dir (const std::string& x)
{
  this->output_dir_ = x;
}

inline bool options::
output_dir_specified () const
{
  return this->output_dir_specified_;
}

inline void options::
output_dir_specified (bool x)
{
  this->output_dir_specified_ = x;
}

inline const std::string& options::
input_name () const
{
  return this->input_name_;
}

inline std::string& options::
input_name ()
{
  return this->input_name_;
}

inline void options::
input_name (const std::string& x)
{
  this->input_name_ = x;
}

inline bool options::
input_name_specified () const
{
  return this->input_name_specified_;
}

inline void options::
input_name_specified (bool x)
{
  this->input_name_specified_ = x;
}

inline const database_map<std::string>& options::
changelog () const
{
  return this->changelog_;
}

inline database_map<std::string>& options::
changelog ()
{
  return this->changelog_;
}

inline void options::
changelog (const database_map<std::string>& x)
{
  this->changelog_ = x;
}

inline bool options::
changelog_specified () const
{
  return this->changelog_specified_;
}

inline void options::
changelog_specified (bool x)
{
  this->changelog_specified_ = x;
}

inline const database_map<std::string>& options::
changelog_in () const
{
  return this->changelog_in_;
}

inline database_map<std::string>& options::
changelog_in ()
{
  return this->changelog_in_;
}

inline void options::
changelog_in (const database_map<std::string>& x)
{
  this->changelog_in_ = x;
}

inline bool options::
changelog_in_specified () const
{
  return this->changelog_in_specified_;
}

inline void options::
changelog_in_specified (bool x)
{
  this->changelog_in_specified_ = x;
}

inline const database_map<std::string>& options::
changelog_out () const
{
  return this->changelog_out_;
}

inline database_map<std::string>& options::
changelog_out ()
{
  return this->changelog_out_;
}

inline void options::
changelog_out (const database_map<std::string>& x)
{
  this->changelog_out_ = x;
}

inline bool options::
changelog_out_specified () const
{
  return this->changelog_out_specified_;
}

inline void options::
changelog_out_specified (bool x)
{
  this->changelog_out_specified_ = x;
}

inline const database_map<std::string>& options::
changelog_dir () const
{
  return this->changelog_dir_;
}

inline database_map<std::string>& options::
changelog_dir ()
{
  return this->changelog_dir_;
}

inline void options::
changelog_dir (const database_map<std::string>& x)
{
  this->changelog_dir_ = x;
}

inline bool options::
changelog_dir_specified () const
{
  return this->changelog_dir_specified_;
}

inline void options::
changelog_dir_specified (bool x)
{
  this->changelog_dir_specified_ = x;
}

inline const bool& options::
init_changelog () const
{
  return this->init_changelog_;
}

inline bool& options::
init_changelog ()
{
  return this->init_changelog_;
}

inline void options::
init_changelog (const bool& x)
{
  this->init_changelog_ = x;
}

inline const database_map<std::string>& options::
odb_file_suffix () const
{
  return this->odb_file_suffix_;
}

inline database_map<std::string>& options::
odb_file_suffix ()
{
  return this->odb_file_suffix_;
}

inline void options::
odb_file_suffix (const database_map<std::string>& x)
{
  this->odb_file_suffix_ = x;
}

inline bool options::
odb_file_suffix_specified () const
{
  return this->odb_file_suffix_specified_;
}

inline void options::
odb_file_suffix_specified (bool x)
{
  this->odb_file_suffix_specified_ = x;
}

inline const database_map<std::string>& options::
sql_file_suffix () const
{
  return this->sql_file_suffix_;
}

inline database_map<std::string>& options::
sql_file_suffix ()
{
  return this->sql_file_suffix_;
}

inline void options::
sql_file_suffix (const database_map<std::string>& x)
{
  this->sql_file_suffix_ = x;
}

inline bool options::
sql_file_suffix_specified () const
{
  return this->sql_file_suffix_specified_;
}

inline void options::
sql_file_suffix_specified (bool x)
{
  this->sql_file_suffix_specified_ = x;
}

inline const database_map<std::string>& options::
schema_file_suffix () const
{
  return this->schema_file_suffix_;
}

inline database_map<std::string>& options::
schema_file_suffix ()
{
  return this->schema_file_suffix_;
}

inline void options::
schema_file_suffix (const database_map<std::string>& x)
{
  this->schema_file_suffix_ = x;
}

inline bool options::
schema_file_suffix_specified () const
{
  return this->schema_file_suffix_specified_;
}

inline void options::
schema_file_suffix_specified (bool x)
{
  this->schema_file_suffix_specified_ = x;
}

inline const database_map<std::string>& options::
changelog_file_suffix () const
{
  return this->changelog_file_suffix_;
}

inline database_map<std::string>& options::
changelog_file_suffix ()
{
  return this->changelog_file_suffix_;
}

inline void options::
changelog_file_suffix (const database_map<std::string>& x)
{
  this->changelog_file_suffix_ = x;
}

inline bool options::
changelog_file_suffix_specified () const
{
  return this->changelog_file_suffix_specified_;
}

inline void options::
changelog_file_suffix_specified (bool x)
{
  this->changelog_file_suffix_specified_ = x;
}

inline const std::string& options::
hxx_suffix () const
{
  return this->hxx_suffix_;
}

inline std::string& options::
hxx_suffix ()
{
  return this->hxx_suffix_;
}

inline void options::
hxx_suffix (const std::string& x)
{
  this->hxx_suffix_ = x;
}

inline bool options::
hxx_suffix_specified () const
{
  return this->hxx_suffix_specified_;
}

inline void options::
hxx_suffix_specified (bool x)
{
  this->hxx_suffix_specified_ = x;
}

inline const std::string& options::
ixx_suffix () const
{
  return this->ixx_suffix_;
}

inline std::string& options::
ixx_suffix ()
{
  return this->ixx_suffix_;
}

inline void options::
ixx_suffix (const std::string& x)
{
  this->ixx_suffix_ = x;
}

inline bool options::
ixx_suffix_specified () const
{
  return this->ixx_suffix_specified_;
}

inline void options::
ixx_suffix_specified (bool x)
{
  this->ixx_suffix_specified_ = x;
}

inline const std::string& options::
cxx_suffix () const
{
  return this->cxx_suffix_;
}

inline std::string& options::
cxx_suffix ()
{
  return this->cxx_suffix_;
}

inline void options::
cxx_suffix (const std::string& x)
{
  this->cxx_suffix_ = x;
}

inline bool options::
cxx_suffix_specified () const
{
  return this->cxx_suffix_specified_;
}

inline void options::
cxx_suffix_specified (bool x)
{
  this->cxx_suffix_specified_ = x;
}

inline const std::string& options::
sql_suffix () const
{
  return this->sql_suffix_;
}

inline std::string& options::
sql_suffix ()
{
  return this->sql_suffix_;
}

inline void options::
sql_suffix (const std::string& x)
{
  this->sql_suffix_ = x;
}

inline bool options::
sql_suffix_specified () const
{
  return this->sql_suffix_specified_;
}

inline void options::
sql_suffix_specified (bool x)
{
  this->sql_suffix_specified_ = x;
}

inline const std::string& options::
changelog_suffix () const
{
  return this->changelog_suffix_;
}

inline std::string& options::
changelog_suffix ()
{
  return this->changelog_suffix_;
}

inline void options::
changelog_suffix (const std::string& x)
{
  this->changelog_suffix_ = x;
}

inline bool options::
changelog_suffix_specified () const
{
  return this->changelog_suffix_specified_;
}

inline void options::
changelog_suffix_specified (bool x)
{
  this->changelog_suffix_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
hxx_prologue () const
{
  return this->hxx_prologue_;
}

inline database_map<std::vector<std::string> >& options::
hxx_prologue ()
{
  return this->hxx_prologue_;
}

inline void options::
hxx_prologue (const database_map<std::vector<std::string> >& x)
{
  this->hxx_prologue_ = x;
}

inline bool options::
hxx_prologue_specified () const
{
  return this->hxx_prologue_specified_;
}

inline void options::
hxx_prologue_specified (bool x)
{
  this->hxx_prologue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
ixx_prologue () const
{
  return this->ixx_prologue_;
}

inline database_map<std::vector<std::string> >& options::
ixx_prologue ()
{
  return this->ixx_prologue_;
}

inline void options::
ixx_prologue (const database_map<std::vector<std::string> >& x)
{
  this->ixx_prologue_ = x;
}

inline bool options::
ixx_prologue_specified () const
{
  return this->ixx_prologue_specified_;
}

inline void options::
ixx_prologue_specified (bool x)
{
  this->ixx_prologue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
cxx_prologue () const
{
  return this->cxx_prologue_;
}

inline database_map<std::vector<std::string> >& options::
cxx_prologue ()
{
  return this->cxx_prologue_;
}

inline void options::
cxx_prologue (const database_map<std::vector<std::string> >& x)
{
  this->cxx_prologue_ = x;
}

inline bool options::
cxx_prologue_specified () const
{
  return this->cxx_prologue_specified_;
}

inline void options::
cxx_prologue_specified (bool x)
{
  this->cxx_prologue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
schema_prologue () const
{
  return this->schema_prologue_;
}

inline database_map<std::vector<std::string> >& options::
schema_prologue ()
{
  return this->schema_prologue_;
}

inline void options::
schema_prologue (const database_map<std::vector<std::string> >& x)
{
  this->schema_prologue_ = x;
}

inline bool options::
schema_prologue_specified () const
{
  return this->schema_prologue_specified_;
}

inline void options::
schema_prologue_specified (bool x)
{
  this->schema_prologue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
sql_prologue () const
{
  return this->sql_prologue_;
}

inline database_map<std::vector<std::string> >& options::
sql_prologue ()
{
  return this->sql_prologue_;
}

inline void options::
sql_prologue (const database_map<std::vector<std::string> >& x)
{
  this->sql_prologue_ = x;
}

inline bool options::
sql_prologue_specified () const
{
  return this->sql_prologue_specified_;
}

inline void options::
sql_prologue_specified (bool x)
{
  this->sql_prologue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
migration_prologue () const
{
  return this->migration_prologue_;
}

inline database_map<std::vector<std::string> >& options::
migration_prologue ()
{
  return this->migration_prologue_;
}

inline void options::
migration_prologue (const database_map<std::vector<std::string> >& x)
{
  this->migration_prologue_ = x;
}

inline bool options::
migration_prologue_specified () const
{
  return this->migration_prologue_specified_;
}

inline void options::
migration_prologue_specified (bool x)
{
  this->migration_prologue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
sql_interlude () const
{
  return this->sql_interlude_;
}

inline database_map<std::vector<std::string> >& options::
sql_interlude ()
{
  return this->sql_interlude_;
}

inline void options::
sql_interlude (const database_map<std::vector<std::string> >& x)
{
  this->sql_interlude_ = x;
}

inline bool options::
sql_interlude_specified () const
{
  return this->sql_interlude_specified_;
}

inline void options::
sql_interlude_specified (bool x)
{
  this->sql_interlude_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
hxx_epilogue () const
{
  return this->hxx_epilogue_;
}

inline database_map<std::vector<std::string> >& options::
hxx_epilogue ()
{
  return this->hxx_epilogue_;
}

inline void options::
hxx_epilogue (const database_map<std::vector<std::string> >& x)
{
  this->hxx_epilogue_ = x;
}

inline bool options::
hxx_epilogue_specified () const
{
  return this->hxx_epilogue_specified_;
}

inline void options::
hxx_epilogue_specified (bool x)
{
  this->hxx_epilogue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
ixx_epilogue () const
{
  return this->ixx_epilogue_;
}

inline database_map<std::vector<std::string> >& options::
ixx_epilogue ()
{
  return this->ixx_epilogue_;
}

inline void options::
ixx_epilogue (const database_map<std::vector<std::string> >& x)
{
  this->ixx_epilogue_ = x;
}

inline bool options::
ixx_epilogue_specified () const
{
  return this->ixx_epilogue_specified_;
}

inline void options::
ixx_epilogue_specified (bool x)
{
  this->ixx_epilogue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
cxx_epilogue () const
{
  return this->cxx_epilogue_;
}

inline database_map<std::vector<std::string> >& options::
cxx_epilogue ()
{
  return this->cxx_epilogue_;
}

inline void options::
cxx_epilogue (const database_map<std::vector<std::string> >& x)
{
  this->cxx_epilogue_ = x;
}

inline bool options::
cxx_epilogue_specified () const
{
  return this->cxx_epilogue_specified_;
}

inline void options::
cxx_epilogue_specified (bool x)
{
  this->cxx_epilogue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
schema_epilogue () const
{
  return this->schema_epilogue_;
}

inline database_map<std::vector<std::string> >& options::
schema_epilogue ()
{
  return this->schema_epilogue_;
}

inline void options::
schema_epilogue (const database_map<std::vector<std::string> >& x)
{
  this->schema_epilogue_ = x;
}

inline bool options::
schema_epilogue_specified () const
{
  return this->schema_epilogue_specified_;
}

inline void options::
schema_epilogue_specified (bool x)
{
  this->schema_epilogue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
sql_epilogue () const
{
  return this->sql_epilogue_;
}

inline database_map<std::vector<std::string> >& options::
sql_epilogue ()
{
  return this->sql_epilogue_;
}

inline void options::
sql_epilogue (const database_map<std::vector<std::string> >& x)
{
  this->sql_epilogue_ = x;
}

inline bool options::
sql_epilogue_specified () const
{
  return this->sql_epilogue_specified_;
}

inline void options::
sql_epilogue_specified (bool x)
{
  this->sql_epilogue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
migration_epilogue () const
{
  return this->migration_epilogue_;
}

inline database_map<std::vector<std::string> >& options::
migration_epilogue ()
{
  return this->migration_epilogue_;
}

inline void options::
migration_epilogue (const database_map<std::vector<std::string> >& x)
{
  this->migration_epilogue_ = x;
}

inline bool options::
migration_epilogue_specified () const
{
  return this->migration_epilogue_specified_;
}

inline void options::
migration_epilogue_specified (bool x)
{
  this->migration_epilogue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
hxx_prologue_file () const
{
  return this->hxx_prologue_file_;
}

inline database_map<std::vector<std::string> >& options::
hxx_prologue_file ()
{
  return this->hxx_prologue_file_;
}

inline void options::
hxx_prologue_file (const database_map<std::vector<std::string> >& x)
{
  this->hxx_prologue_file_ = x;
}

inline bool options::
hxx_prologue_file_specified () const
{
  return this->hxx_prologue_file_specified_;
}

inline void options::
hxx_prologue_file_specified (bool x)
{
  this->hxx_prologue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
ixx_prologue_file () const
{
  return this->ixx_prologue_file_;
}

inline database_map<std::vector<std::string> >& options::
ixx_prologue_file ()
{
  return this->ixx_prologue_file_;
}

inline void options::
ixx_prologue_file (const database_map<std::vector<std::string> >& x)
{
  this->ixx_prologue_file_ = x;
}

inline bool options::
ixx_prologue_file_specified () const
{
  return this->ixx_prologue_file_specified_;
}

inline void options::
ixx_prologue_file_specified (bool x)
{
  this->ixx_prologue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
cxx_prologue_file () const
{
  return this->cxx_prologue_file_;
}

inline database_map<std::vector<std::string> >& options::
cxx_prologue_file ()
{
  return this->cxx_prologue_file_;
}

inline void options::
cxx_prologue_file (const database_map<std::vector<std::string> >& x)
{
  this->cxx_prologue_file_ = x;
}

inline bool options::
cxx_prologue_file_specified () const
{
  return this->cxx_prologue_file_specified_;
}

inline void options::
cxx_prologue_file_specified (bool x)
{
  this->cxx_prologue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
schema_prologue_file () const
{
  return this->schema_prologue_file_;
}

inline database_map<std::vector<std::string> >& options::
schema_prologue_file ()
{
  return this->schema_prologue_file_;
}

inline void options::
schema_prologue_file (const database_map<std::vector<std::string> >& x)
{
  this->schema_prologue_file_ = x;
}

inline bool options::
schema_prologue_file_specified () const
{
  return this->schema_prologue_file_specified_;
}

inline void options::
schema_prologue_file_specified (bool x)
{
  this->schema_prologue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
sql_prologue_file () const
{
  return this->sql_prologue_file_;
}

inline database_map<std::vector<std::string> >& options::
sql_prologue_file ()
{
  return this->sql_prologue_file_;
}

inline void options::
sql_prologue_file (const database_map<std::vector<std::string> >& x)
{
  this->sql_prologue_file_ = x;
}

inline bool options::
sql_prologue_file_specified () const
{
  return this->sql_prologue_file_specified_;
}

inline void options::
sql_prologue_file_specified (bool x)
{
  this->sql_prologue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
migration_prologue_file () const
{
  return this->migration_prologue_file_;
}

inline database_map<std::vector<std::string> >& options::
migration_prologue_file ()
{
  return this->migration_prologue_file_;
}

inline void options::
migration_prologue_file (const database_map<std::vector<std::string> >& x)
{
  this->migration_prologue_file_ = x;
}

inline bool options::
migration_prologue_file_specified () const
{
  return this->migration_prologue_file_specified_;
}

inline void options::
migration_prologue_file_specified (bool x)
{
  this->migration_prologue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
sql_interlude_file () const
{
  return this->sql_interlude_file_;
}

inline database_map<std::vector<std::string> >& options::
sql_interlude_file ()
{
  return this->sql_interlude_file_;
}

inline void options::
sql_interlude_file (const database_map<std::vector<std::string> >& x)
{
  this->sql_interlude_file_ = x;
}

inline bool options::
sql_interlude_file_specified () const
{
  return this->sql_interlude_file_specified_;
}

inline void options::
sql_interlude_file_specified (bool x)
{
  this->sql_interlude_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
hxx_epilogue_file () const
{
  return this->hxx_epilogue_file_;
}

inline database_map<std::vector<std::string> >& options::
hxx_epilogue_file ()
{
  return this->hxx_epilogue_file_;
}

inline void options::
hxx_epilogue_file (const database_map<std::vector<std::string> >& x)
{
  this->hxx_epilogue_file_ = x;
}

inline bool options::
hxx_epilogue_file_specified () const
{
  return this->hxx_epilogue_file_specified_;
}

inline void options::
hxx_epilogue_file_specified (bool x)
{
  this->hxx_epilogue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
ixx_epilogue_file () const
{
  return this->ixx_epilogue_file_;
}

inline database_map<std::vector<std::string> >& options::
ixx_epilogue_file ()
{
  return this->ixx_epilogue_file_;
}

inline void options::
ixx_epilogue_file (const database_map<std::vector<std::string> >& x)
{
  this->ixx_epilogue_file_ = x;
}

inline bool options::
ixx_epilogue_file_specified () const
{
  return this->ixx_epilogue_file_specified_;
}

inline void options::
ixx_epilogue_file_specified (bool x)
{
  this->ixx_epilogue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
cxx_epilogue_file () const
{
  return this->cxx_epilogue_file_;
}

inline database_map<std::vector<std::string> >& options::
cxx_epilogue_file ()
{
  return this->cxx_epilogue_file_;
}

inline void options::
cxx_epilogue_file (const database_map<std::vector<std::string> >& x)
{
  this->cxx_epilogue_file_ = x;
}

inline bool options::
cxx_epilogue_file_specified () const
{
  return this->cxx_epilogue_file_specified_;
}

inline void options::
cxx_epilogue_file_specified (bool x)
{
  this->cxx_epilogue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
schema_epilogue_file () const
{
  return this->schema_epilogue_file_;
}

inline database_map<std::vector<std::string> >& options::
schema_epilogue_file ()
{
  return this->schema_epilogue_file_;
}

inline void options::
schema_epilogue_file (const database_map<std::vector<std::string> >& x)
{
  this->schema_epilogue_file_ = x;
}

inline bool options::
schema_epilogue_file_specified () const
{
  return this->schema_epilogue_file_specified_;
}

inline void options::
schema_epilogue_file_specified (bool x)
{
  this->schema_epilogue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
sql_epilogue_file () const
{
  return this->sql_epilogue_file_;
}

inline database_map<std::vector<std::string> >& options::
sql_epilogue_file ()
{
  return this->sql_epilogue_file_;
}

inline void options::
sql_epilogue_file (const database_map<std::vector<std::string> >& x)
{
  this->sql_epilogue_file_ = x;
}

inline bool options::
sql_epilogue_file_specified () const
{
  return this->sql_epilogue_file_specified_;
}

inline void options::
sql_epilogue_file_specified (bool x)
{
  this->sql_epilogue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
migration_epilogue_file () const
{
  return this->migration_epilogue_file_;
}

inline database_map<std::vector<std::string> >& options::
migration_epilogue_file ()
{
  return this->migration_epilogue_file_;
}

inline void options::
migration_epilogue_file (const database_map<std::vector<std::string> >& x)
{
  this->migration_epilogue_file_ = x;
}

inline bool options::
migration_epilogue_file_specified () const
{
  return this->migration_epilogue_file_specified_;
}

inline void options::
migration_epilogue_file_specified (bool x)
{
  this->migration_epilogue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
odb_prologue () const
{
  return this->odb_prologue_;
}

inline database_map<std::vector<std::string> >& options::
odb_prologue ()
{
  return this->odb_prologue_;
}

inline void options::
odb_prologue (const database_map<std::vector<std::string> >& x)
{
  this->odb_prologue_ = x;
}

inline bool options::
odb_prologue_specified () const
{
  return this->odb_prologue_specified_;
}

inline void options::
odb_prologue_specified (bool x)
{
  this->odb_prologue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
odb_prologue_file () const
{
  return this->odb_prologue_file_;
}

inline database_map<std::vector<std::string> >& options::
odb_prologue_file ()
{
  return this->odb_prologue_file_;
}

inline void options::
odb_prologue_file (const database_map<std::vector<std::string> >& x)
{
  this->odb_prologue_file_ = x;
}

inline bool options::
odb_prologue_file_specified () const
{
  return this->odb_prologue_file_specified_;
}

inline void options::
odb_prologue_file_specified (bool x)
{
  this->odb_prologue_file_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
odb_epilogue () const
{
  return this->odb_epilogue_;
}

inline database_map<std::vector<std::string> >& options::
odb_epilogue ()
{
  return this->odb_epilogue_;
}

inline void options::
odb_epilogue (const database_map<std::vector<std::string> >& x)
{
  this->odb_epilogue_ = x;
}

inline bool options::
odb_epilogue_specified () const
{
  return this->odb_epilogue_specified_;
}

inline void options::
odb_epilogue_specified (bool x)
{
  this->odb_epilogue_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
odb_epilogue_file () const
{
  return this->odb_epilogue_file_;
}

inline database_map<std::vector<std::string> >& options::
odb_epilogue_file ()
{
  return this->odb_epilogue_file_;
}

inline void options::
odb_epilogue_file (const database_map<std::vector<std::string> >& x)
{
  this->odb_epilogue_file_ = x;
}

inline bool options::
odb_epilogue_file_specified () const
{
  return this->odb_epilogue_file_specified_;
}

inline void options::
odb_epilogue_file_specified (bool x)
{
  this->odb_epilogue_file_specified_ = x;
}

inline const database_map<std::string>& options::
table_prefix () const
{
  return this->table_prefix_;
}

inline database_map<std::string>& options::
table_prefix ()
{
  return this->table_prefix_;
}

inline void options::
table_prefix (const database_map<std::string>& x)
{
  this->table_prefix_ = x;
}

inline bool options::
table_prefix_specified () const
{
  return this->table_prefix_specified_;
}

inline void options::
table_prefix_specified (bool x)
{
  this->table_prefix_specified_ = x;
}

inline const database_map<std::string>& options::
index_suffix () const
{
  return this->index_suffix_;
}

inline database_map<std::string>& options::
index_suffix ()
{
  return this->index_suffix_;
}

inline void options::
index_suffix (const database_map<std::string>& x)
{
  this->index_suffix_ = x;
}

inline bool options::
index_suffix_specified () const
{
  return this->index_suffix_specified_;
}

inline void options::
index_suffix_specified (bool x)
{
  this->index_suffix_specified_ = x;
}

inline const database_map<std::string>& options::
fkey_suffix () const
{
  return this->fkey_suffix_;
}

inline database_map<std::string>& options::
fkey_suffix ()
{
  return this->fkey_suffix_;
}

inline void options::
fkey_suffix (const database_map<std::string>& x)
{
  this->fkey_suffix_ = x;
}

inline bool options::
fkey_suffix_specified () const
{
  return this->fkey_suffix_specified_;
}

inline void options::
fkey_suffix_specified (bool x)
{
  this->fkey_suffix_specified_ = x;
}

inline const database_map<std::string>& options::
sequence_suffix () const
{
  return this->sequence_suffix_;
}

inline database_map<std::string>& options::
sequence_suffix ()
{
  return this->sequence_suffix_;
}

inline void options::
sequence_suffix (const database_map<std::string>& x)
{
  this->sequence_suffix_ = x;
}

inline bool options::
sequence_suffix_specified () const
{
  return this->sequence_suffix_specified_;
}

inline void options::
sequence_suffix_specified (bool x)
{
  this->sequence_suffix_specified_ = x;
}

inline const database_map<name_case>& options::
sql_name_case () const
{
  return this->sql_name_case_;
}

inline database_map<name_case>& options::
sql_name_case ()
{
  return this->sql_name_case_;
}

inline void options::
sql_name_case (const database_map<name_case>& x)
{
  this->sql_name_case_ = x;
}

inline bool options::
sql_name_case_specified () const
{
  return this->sql_name_case_specified_;
}

inline void options::
sql_name_case_specified (bool x)
{
  this->sql_name_case_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
table_regex () const
{
  return this->table_regex_;
}

inline database_map<std::vector<std::string> >& options::
table_regex ()
{
  return this->table_regex_;
}

inline void options::
table_regex (const database_map<std::vector<std::string> >& x)
{
  this->table_regex_ = x;
}

inline bool options::
table_regex_specified () const
{
  return this->table_regex_specified_;
}

inline void options::
table_regex_specified (bool x)
{
  this->table_regex_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
column_regex () const
{
  return this->column_regex_;
}

inline database_map<std::vector<std::string> >& options::
column_regex ()
{
  return this->column_regex_;
}

inline void options::
column_regex (const database_map<std::vector<std::string> >& x)
{
  this->column_regex_ = x;
}

inline bool options::
column_regex_specified () const
{
  return this->column_regex_specified_;
}

inline void options::
column_regex_specified (bool x)
{
  this->column_regex_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
index_regex () const
{
  return this->index_regex_;
}

inline database_map<std::vector<std::string> >& options::
index_regex ()
{
  return this->index_regex_;
}

inline void options::
index_regex (const database_map<std::vector<std::string> >& x)
{
  this->index_regex_ = x;
}

inline bool options::
index_regex_specified () const
{
  return this->index_regex_specified_;
}

inline void options::
index_regex_specified (bool x)
{
  this->index_regex_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
fkey_regex () const
{
  return this->fkey_regex_;
}

inline database_map<std::vector<std::string> >& options::
fkey_regex ()
{
  return this->fkey_regex_;
}

inline void options::
fkey_regex (const database_map<std::vector<std::string> >& x)
{
  this->fkey_regex_ = x;
}

inline bool options::
fkey_regex_specified () const
{
  return this->fkey_regex_specified_;
}

inline void options::
fkey_regex_specified (bool x)
{
  this->fkey_regex_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
sequence_regex () const
{
  return this->sequence_regex_;
}

inline database_map<std::vector<std::string> >& options::
sequence_regex ()
{
  return this->sequence_regex_;
}

inline void options::
sequence_regex (const database_map<std::vector<std::string> >& x)
{
  this->sequence_regex_ = x;
}

inline bool options::
sequence_regex_specified () const
{
  return this->sequence_regex_specified_;
}

inline void options::
sequence_regex_specified (bool x)
{
  this->sequence_regex_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
statement_regex () const
{
  return this->statement_regex_;
}

inline database_map<std::vector<std::string> >& options::
statement_regex ()
{
  return this->statement_regex_;
}

inline void options::
statement_regex (const database_map<std::vector<std::string> >& x)
{
  this->statement_regex_ = x;
}

inline bool options::
statement_regex_specified () const
{
  return this->statement_regex_specified_;
}

inline void options::
statement_regex_specified (bool x)
{
  this->statement_regex_specified_ = x;
}

inline const database_map<std::vector<std::string> >& options::
sql_name_regex () const
{
  return this->sql_name_regex_;
}

inline database_map<std::vector<std::string> >& options::
sql_name_regex ()
{
  return this->sql_name_regex_;
}

inline void options::
sql_name_regex (const database_map<std::vector<std::string> >& x)
{
  this->sql_name_regex_ = x;
}

inline bool options::
sql_name_regex_specified () const
{
  return this->sql_name_regex_specified_;
}

inline void options::
sql_name_regex_specified (bool x)
{
  this->sql_name_regex_specified_ = x;
}

inline const bool& options::
sql_name_regex_trace () const
{
  return this->sql_name_regex_trace_;
}

inline bool& options::
sql_name_regex_trace ()
{
  return this->sql_name_regex_trace_;
}

inline void options::
sql_name_regex_trace (const bool& x)
{
  this->sql_name_regex_trace_ = x;
}

inline const std::vector<std::string>& options::
accessor_regex () const
{
  return this->accessor_regex_;
}

inline std::vector<std::string>& options::
accessor_regex ()
{
  return this->accessor_regex_;
}

inline void options::
accessor_regex (const std::vector<std::string>& x)
{
  this->accessor_regex_ = x;
}

inline bool options::
accessor_regex_specified () const
{
  return this->accessor_regex_specified_;
}

inline void options::
accessor_regex_specified (bool x)
{
  this->accessor_regex_specified_ = x;
}

inline const bool& options::
accessor_regex_trace () const
{
  return this->accessor_regex_trace_;
}

inline bool& options::
accessor_regex_trace ()
{
  return this->accessor_regex_trace_;
}

inline void options::
accessor_regex_trace (const bool& x)
{
  this->accessor_regex_trace_ = x;
}

inline const std::vector<std::string>& options::
modifier_regex () const
{
  return this->modifier_regex_;
}

inline std::vector<std::string>& options::
modifier_regex ()
{
  return this->modifier_regex_;
}

inline void options::
modifier_regex (const std::vector<std::string>& x)
{
  this->modifier_regex_ = x;
}

inline bool options::
modifier_regex_specified () const
{
  return this->modifier_regex_specified_;
}

inline void options::
modifier_regex_specified (bool x)
{
  this->modifier_regex_specified_ = x;
}

inline const bool& options::
modifier_regex_trace () const
{
  return this->modifier_regex_trace_;
}

inline bool& options::
modifier_regex_trace ()
{
  return this->modifier_regex_trace_;
}

inline void options::
modifier_regex_trace (const bool& x)
{
  this->modifier_regex_trace_ = x;
}

inline const bool& options::
include_with_brackets () const
{
  return this->include_with_brackets_;
}

inline bool& options::
include_with_brackets ()
{
  return this->include_with_brackets_;
}

inline void options::
include_with_brackets (const bool& x)
{
  this->include_with_brackets_ = x;
}

inline const std::string& options::
include_prefix () const
{
  return this->include_prefix_;
}

inline std::string& options::
include_prefix ()
{
  return this->include_prefix_;
}

inline void options::
include_prefix (const std::string& x)
{
  this->include_prefix_ = x;
}

inline bool options::
include_prefix_specified () const
{
  return this->include_prefix_specified_;
}

inline void options::
include_prefix_specified (bool x)
{
  this->include_prefix_specified_ = x;
}

inline const std::vector<std::string>& options::
include_regex () const
{
  return this->include_regex_;
}

inline std::vector<std::string>& options::
include_regex ()
{
  return this->include_regex_;
}

inline void options::
include_regex (const std::vector<std::string>& x)
{
  this->include_regex_ = x;
}

inline bool options::
include_regex_specified () const
{
  return this->include_regex_specified_;
}

inline void options::
include_regex_specified (bool x)
{
  this->include_regex_specified_ = x;
}

inline const bool& options::
include_regex_trace () const
{
  return this->include_regex_trace_;
}

inline bool& options::
include_regex_trace ()
{
  return this->include_regex_trace_;
}

inline void options::
include_regex_trace (const bool& x)
{
  this->include_regex_trace_ = x;
}

inline const std::string& options::
guard_prefix () const
{
  return this->guard_prefix_;
}

inline std::string& options::
guard_prefix ()
{
  return this->guard_prefix_;
}

inline void options::
guard_prefix (const std::string& x)
{
  this->guard_prefix_ = x;
}

inline bool options::
guard_prefix_specified () const
{
  return this->guard_prefix_specified_;
}

inline void options::
guard_prefix_specified (bool x)
{
  this->guard_prefix_specified_ = x;
}

inline const bool& options::
show_sloc () const
{
  return this->show_sloc_;
}

inline bool& options::
show_sloc ()
{
  return this->show_sloc_;
}

inline void options::
show_sloc (const bool& x)
{
  this->show_sloc_ = x;
}

inline const std::size_t& options::
sloc_limit () const
{
  return this->sloc_limit_;
}

inline std::size_t& options::
sloc_limit ()
{
  return this->sloc_limit_;
}

inline void options::
sloc_limit (const std::size_t& x)
{
  this->sloc_limit_ = x;
}

inline bool options::
sloc_limit_specified () const
{
  return this->sloc_limit_specified_;
}

inline void options::
sloc_limit_specified (bool x)
{
  this->sloc_limit_specified_ = x;
}

inline const std::string& options::
options_file () const
{
  return this->options_file_;
}

inline std::string& options::
options_file ()
{
  return this->options_file_;
}

inline void options::
options_file (const std::string& x)
{
  this->options_file_ = x;
}

inline bool options::
options_file_specified () const
{
  return this->options_file_specified_;
}

inline void options::
options_file_specified (bool x)
{
  this->options_file_specified_ = x;
}

inline const std::vector<std::string>& options::
x () const
{
  return this->x_;
}

inline std::vector<std::string>& options::
x ()
{
  return this->x_;
}

inline void options::
x (const std::vector<std::string>& x)
{
  this->x_ = x;
}

inline bool options::
x_specified () const
{
  return this->x_specified_;
}

inline void options::
x_specified (bool x)
{
  this->x_specified_ = x;
}

inline const bool& options::
v () const
{
  return this->v_;
}

inline bool& options::
v ()
{
  return this->v_;
}

inline void options::
v (const bool& x)
{
  this->v_ = x;
}

inline const bool& options::
trace () const
{
  return this->trace_;
}

inline bool& options::
trace ()
{
  return this->trace_;
}

inline void options::
trace (const bool& x)
{
  this->trace_ = x;
}

inline const std::string& options::
mysql_engine () const
{
  return this->mysql_engine_;
}

inline std::string& options::
mysql_engine ()
{
  return this->mysql_engine_;
}

inline void options::
mysql_engine (const std::string& x)
{
  this->mysql_engine_ = x;
}

inline bool options::
mysql_engine_specified () const
{
  return this->mysql_engine_specified_;
}

inline void options::
mysql_engine_specified (bool x)
{
  this->mysql_engine_specified_ = x;
}

inline const bool& options::
sqlite_override_null () const
{
  return this->sqlite_override_null_;
}

inline bool& options::
sqlite_override_null ()
{
  return this->sqlite_override_null_;
}

inline void options::
sqlite_override_null (const bool& x)
{
  this->sqlite_override_null_ = x;
}

inline const bool& options::
sqlite_lax_auto_id () const
{
  return this->sqlite_lax_auto_id_;
}

inline bool& options::
sqlite_lax_auto_id ()
{
  return this->sqlite_lax_auto_id_;
}

inline void options::
sqlite_lax_auto_id (const bool& x)
{
  this->sqlite_lax_auto_id_ = x;
}

inline const ::pgsql_version& options::
pgsql_server_version () const
{
  return this->pgsql_server_version_;
}

inline ::pgsql_version& options::
pgsql_server_version ()
{
  return this->pgsql_server_version_;
}

inline void options::
pgsql_server_version (const ::pgsql_version& x)
{
  this->pgsql_server_version_ = x;
}

inline bool options::
pgsql_server_version_specified () const
{
  return this->pgsql_server_version_specified_;
}

inline void options::
pgsql_server_version_specified (bool x)
{
  this->pgsql_server_version_specified_ = x;
}

inline const ::oracle_version& options::
oracle_client_version () const
{
  return this->oracle_client_version_;
}

inline ::oracle_version& options::
oracle_client_version ()
{
  return this->oracle_client_version_;
}

inline void options::
oracle_client_version (const ::oracle_version& x)
{
  this->oracle_client_version_ = x;
}

inline bool options::
oracle_client_version_specified () const
{
  return this->oracle_client_version_specified_;
}

inline void options::
oracle_client_version_specified (bool x)
{
  this->oracle_client_version_specified_ = x;
}

inline const bool& options::
oracle_warn_truncation () const
{
  return this->oracle_warn_truncation_;
}

inline bool& options::
oracle_warn_truncation ()
{
  return this->oracle_warn_truncation_;
}

inline void options::
oracle_warn_truncation (const bool& x)
{
  this->oracle_warn_truncation_ = x;
}

inline const ::mssql_version& options::
mssql_server_version () const
{
  return this->mssql_server_version_;
}

inline ::mssql_version& options::
mssql_server_version ()
{
  return this->mssql_server_version_;
}

inline void options::
mssql_server_version (const ::mssql_version& x)
{
  this->mssql_server_version_ = x;
}

inline bool options::
mssql_server_version_specified () const
{
  return this->mssql_server_version_specified_;
}

inline void options::
mssql_server_version_specified (bool x)
{
  this->mssql_server_version_specified_ = x;
}

inline const unsigned int& options::
mssql_short_limit () const
{
  return this->mssql_short_limit_;
}

inline unsigned int& options::
mssql_short_limit ()
{
  return this->mssql_short_limit_;
}

inline void options::
mssql_short_limit (const unsigned int& x)
{
  this->mssql_short_limit_ = x;
}

inline bool options::
mssql_short_limit_specified () const
{
  return this->mssql_short_limit_specified_;
}

inline void options::
mssql_short_limit_specified (bool x)
{
  this->mssql_short_limit_specified_ = x;
}

// Begin epilogue.
//
//
// End epilogue.
