// All checks required for FFmpeg source.
// NOTE: Those commented out have been determined to not be in use.

#ifndef FFMPEG_CONFIG_H
#define FFMPEG_CONFIG_H

#cmakedefine FFMPEG_CONFIGURATION
#define FFMPEG_LICENSE @FFMPEG_LICENSE@
#define CONFIG_THIS_YEAR @CONFIG_THIS_YEAR@

#define SWS_MAX_FILTER_SIZE @SWS_MAX_FILTER_SIZE@

#define BUILDSUF @BUILDSUF@
#define SLIBSUF @SLIBSUF@
#define EXTERN_PREFIX @EXTERN_PREFIX@
#define EXTERN_ASM @EXTERN_ASM@

// From config_cpu.h.
//
#cmakedefine01 ARCH_AARCH64
#cmakedefine01 ARCH_ALPHA
#cmakedefine01 ARCH_ARM
#cmakedefine01 ARCH_ARMV8
#cmakedefine01 HAVE_ARMV8
#cmakedefine01 ARCH_AVR32
#cmakedefine01 ARCH_IA64
#cmakedefine01 ARCH_LOONGARCH
#cmakedefine01 ARCH_LOONGARCH64
#cmakedefine01 ARCH_MIPS
#cmakedefine01 ARCH_PPC
#cmakedefine01 ARCH_RISCV
#cmakedefine01 ARCH_SH4
#cmakedefine01 ARCH_X86
#cmakedefine01 ARCH_X86_32
#cmakedefine01 ARCH_X86_64

#define AS_ARCH_LEVEL @AS_ARCH_LEVEL@

// From config-autoconf-checks.h.
//
// TODO: Keep this list up to date with config-autoconf-checks.h.in and the
//       autoconf_macros variable in the buildfile.
//
#cmakedefine01 HAVE_ACCESS
#cmakedefine01 HAVE_ALIGNED_MALLOC
#cmakedefine01 HAVE_ALTIVEC
#cmakedefine01 HAVE_ARC4RANDOM_BUF
#cmakedefine01 HAVE_ARM_ASM
#cmakedefine01 HAVE_ARPA_INET_H
#cmakedefine01 HAVE_ASM_TYPES_H
#cmakedefine01 HAVE_AS_ARCHEXT_DOTPROD_DIRECTIVE
#cmakedefine01 HAVE_AS_ARCHEXT_I8MM_DIRECTIVE
#cmakedefine01 HAVE_AS_ARCH_DIRECTIVE
#cmakedefine01 HAVE_AS_DN_DIRECTIVE
#cmakedefine01 HAVE_AS_FPU_DIRECTIVE
#cmakedefine01 HAVE_AS_FUNC
#cmakedefine01 HAVE_AS_OBJECT_ARCH
#cmakedefine01 HAVE_ATAN2F
#cmakedefine01 HAVE_ATANF
#cmakedefine01 HAVE_AVX
#cmakedefine01 HAVE_AVX2
#cmakedefine01 HAVE_AVX512
#cmakedefine01 HAVE_AVX512ICL
#cmakedefine01 HAVE_BIGENDIAN
#cmakedefine01 HAVE_CBRT
#cmakedefine01 HAVE_CBRTF
#cmakedefine01 HAVE_CLOCK_GETTIME
#cmakedefine01 HAVE_CLOSESOCKET
#cmakedefine01 HAVE_COMMANDLINETOARGVW
#cmakedefine01 HAVE_COPYSIGN
#cmakedefine01 HAVE_COSF
#cmakedefine01 HAVE_DCBZL
#cmakedefine01 HAVE_DIRECT_H
#cmakedefine01 HAVE_DIRENT_H
#cmakedefine01 HAVE_DOS_PATHS
#cmakedefine01 HAVE_DXGIDEBUG_H
#cmakedefine01 HAVE_DXVA_H
#cmakedefine01 HAVE_EBP_AVAILABLE
#cmakedefine01 HAVE_EBX_AVAILABLE
#cmakedefine01 HAVE_ERF
#cmakedefine01 HAVE_EXP2
#cmakedefine01 HAVE_EXP2F
#cmakedefine01 HAVE_EXPF
#cmakedefine01 HAVE_FAST_CLZ
#cmakedefine01 HAVE_FAST_CMOV
#cmakedefine01 HAVE_FAST_FLOAT16
#cmakedefine01 HAVE_FAST_UNALIGNED
#cmakedefine01 HAVE_FCNTL
#cmakedefine01 HAVE_FMA3
#cmakedefine01 HAVE_FMA4
#cmakedefine01 HAVE_GETADDRINFO
#cmakedefine01 HAVE_GETAUXVAL
#cmakedefine01 HAVE_GETENV
#cmakedefine01 HAVE_GETHRTIME
#cmakedefine01 HAVE_GETOPT
#cmakedefine01 HAVE_GETRUSAGE
#cmakedefine01 HAVE_GETTIMEOFDAY
#cmakedefine01 HAVE_GLOB
#cmakedefine01 HAVE_GMTIME
#cmakedefine01 HAVE_GMTIME_R
#cmakedefine01 HAVE_GNU_WINDRES
#cmakedefine01 HAVE_HYPOT
#cmakedefine01 HAVE_I686
#cmakedefine01 HAVE_I8MM
#cmakedefine01 HAVE_IBM_ASM
#cmakedefine01 HAVE_INET_ATON
#cmakedefine01 HAVE_INLINE_ASM
#cmakedefine01 HAVE_INLINE_ASM_DIRECT_SYMBOL_REFS
#cmakedefine01 HAVE_INLINE_ASM_NONLOCAL_LABELS
#cmakedefine01 HAVE_ISATTY
#cmakedefine01 HAVE_ISFINITE
#cmakedefine01 HAVE_ISINF
#cmakedefine01 HAVE_ISNAN
#cmakedefine01 HAVE_KCMVIDEOCODECTYPE_HEVC
#cmakedefine01 HAVE_KCMVIDEOCODECTYPE_HEVCWITHALPHA
#cmakedefine01 HAVE_KCMVIDEOCODECTYPE_VP9
#cmakedefine01 HAVE_KCVIMAGEBUFFERCOLORPRIMARIES_ITU_R_2020
#cmakedefine01 HAVE_KCVIMAGEBUFFERTRANSFERFUNCTION_ITU_R_2020
#cmakedefine01 HAVE_KCVIMAGEBUFFERTRANSFERFUNCTION_ITU_R_2100_HLG
#cmakedefine01 HAVE_KCVIMAGEBUFFERTRANSFERFUNCTION_SMPTE_ST_2084_PQ
#cmakedefine01 HAVE_KCVIMAGEBUFFERTRANSFERFUNCTION_SMPTE_ST_428_1
#cmakedefine01 HAVE_KCVIMAGEBUFFERYCBCRMATRIX_ITU_R_2020
#cmakedefine01 HAVE_KCVPIXELFORMATTYPE_420YPCBCR10BIPLANARVIDEORANGE
#cmakedefine01 HAVE_KCVPIXELFORMATTYPE_422YPCBCR10BIPLANARVIDEORANGE
#cmakedefine01 HAVE_KCVPIXELFORMATTYPE_422YPCBCR16BIPLANARVIDEORANGE
#cmakedefine01 HAVE_KCVPIXELFORMATTYPE_422YPCBCR8BIPLANARVIDEORANGE
#cmakedefine01 HAVE_KCVPIXELFORMATTYPE_444YPCBCR10BIPLANARVIDEORANGE
#cmakedefine01 HAVE_KCVPIXELFORMATTYPE_444YPCBCR16BIPLANARVIDEORANGE
#cmakedefine01 HAVE_KCVPIXELFORMATTYPE_444YPCBCR8BIPLANARVIDEORANGE
#cmakedefine01 HAVE_LASX
#cmakedefine01 HAVE_LDBRX
#cmakedefine01 HAVE_LDEXPF
#cmakedefine01 HAVE_LIBC_MSVCRT
#cmakedefine01 HAVE_LINUX_DMA_BUF_H
#cmakedefine01 HAVE_LLRINT
#cmakedefine01 HAVE_LLRINTF
#cmakedefine01 HAVE_LOCALTIME_R
#cmakedefine01 HAVE_LOCAL_ALIGNED
#cmakedefine01 HAVE_LOG10F
#cmakedefine01 HAVE_LOG2
#cmakedefine01 HAVE_LOG2F
#cmakedefine01 HAVE_LOONGSON2
#cmakedefine01 HAVE_LOONGSON3
#cmakedefine01 HAVE_LRINT
#cmakedefine01 HAVE_LRINTF
#cmakedefine01 HAVE_LSTAT
#cmakedefine01 HAVE_LSX
#cmakedefine01 HAVE_MACH_ABSOLUTE_TIME
#cmakedefine01 HAVE_MAPVIEWOFFILE
#cmakedefine01 HAVE_MEMALIGN
#cmakedefine01 HAVE_MKSTEMP
#cmakedefine01 HAVE_MMAL_PARAMETER_VIDEO_MAX_NUM_CALLBACKS
#cmakedefine01 HAVE_MMAP
#cmakedefine01 HAVE_MMI
#cmakedefine01 HAVE_MMX
#cmakedefine01 HAVE_MMXEXT
#cmakedefine01 HAVE_MM_EMPTY
#cmakedefine01 HAVE_MPROTECT
#cmakedefine01 HAVE_MSA
#cmakedefine01 HAVE_NANOSLEEP
#cmakedefine01 HAVE_NEON
#cmakedefine01 HAVE_OS2THREADS
#cmakedefine01 HAVE_PEEKNAMEDPIPE
#cmakedefine01 HAVE_POLL_H
#cmakedefine01 HAVE_POSIX_MEMALIGN
#cmakedefine01 HAVE_POWF
#cmakedefine01 HAVE_PPC4XX
#cmakedefine01 HAVE_PRAGMA_DEPRECATED
#cmakedefine01 HAVE_PRCTL
#cmakedefine01 HAVE_PTHREADS
#cmakedefine01 HAVE_PTHREAD_CANCEL
#cmakedefine01 HAVE_PTHREAD_NP_H
#cmakedefine01 HAVE_PTHREAD_SETNAME_NP
#cmakedefine01 HAVE_PTHREAD_SET_NAME_NP
#cmakedefine01 HAVE_RDTSC
#cmakedefine01 HAVE_RINT
#cmakedefine01 HAVE_ROUND
#cmakedefine01 HAVE_ROUNDF
#cmakedefine01 HAVE_RV
#cmakedefine01 HAVE_RVV
#cmakedefine01 HAVE_SCHED_GETAFFINITY
#cmakedefine01 HAVE_SECITEMIMPORT
#cmakedefine01 HAVE_SECTION_DATA_REL_RO
#cmakedefine01 HAVE_SETCONSOLECTRLHANDLER
#cmakedefine01 HAVE_SETCONSOLETEXTATTRIBUTE
#cmakedefine01 HAVE_SETDLLDIRECTORY
#cmakedefine01 HAVE_SETMODE
#cmakedefine01 HAVE_SETRLIMIT
#cmakedefine01 HAVE_SIMD_ALIGN_16
#cmakedefine01 HAVE_SIMD_ALIGN_32
#cmakedefine01 HAVE_SIMD_ALIGN_64
#cmakedefine01 HAVE_SINF
#cmakedefine01 HAVE_SLEEP
#cmakedefine01 HAVE_SOCKLEN_T
#cmakedefine01 HAVE_SSE
#cmakedefine01 HAVE_SSE2
#cmakedefine01 HAVE_SSE3
#cmakedefine01 HAVE_SSE4
#cmakedefine01 HAVE_SSSE3
#cmakedefine01 HAVE_STRERROR_R
#cmakedefine01 HAVE_STRUCT_ADDRINFO
#cmakedefine01 HAVE_STRUCT_GROUP_SOURCE_REQ
#cmakedefine01 HAVE_STRUCT_IPV6_MREQ
#cmakedefine01 HAVE_STRUCT_IP_MREQ_SOURCE
#cmakedefine01 HAVE_STRUCT_POLLFD
#cmakedefine01 HAVE_STRUCT_RUSAGE_RU_MAXRSS
#cmakedefine01 HAVE_STRUCT_SOCKADDR_IN6
#cmakedefine01 HAVE_STRUCT_SOCKADDR_SA_LEN
#cmakedefine01 HAVE_STRUCT_SOCKADDR_STORAGE
#cmakedefine01 HAVE_STRUCT_STAT_ST_MTIM_TV_NSEC
#cmakedefine01 HAVE_STRUCT_V4L2_FRMIVALENUM_DISCRETE
#cmakedefine01 HAVE_SYSCONF
#cmakedefine01 HAVE_SYSCTL
#cmakedefine01 HAVE_SYSCTLBYNAME
#cmakedefine01 HAVE_SYS_PARAM_H
#cmakedefine01 HAVE_SYS_RESOURCE_H
#cmakedefine01 HAVE_SYS_SELECT_H
#cmakedefine01 HAVE_SYS_TIME_H
#cmakedefine01 HAVE_SYS_UN_H
#cmakedefine01 HAVE_SYS_VIDEOIO_H
#cmakedefine01 HAVE_TERMIOS_H
#cmakedefine01 HAVE_TRUNC
#cmakedefine01 HAVE_TRUNCF
#cmakedefine01 HAVE_UDPLITE_H
#cmakedefine01 HAVE_UNISTD_H
#cmakedefine01 HAVE_USLEEP
#cmakedefine01 HAVE_UWP
#cmakedefine01 HAVE_VFP
#cmakedefine01 HAVE_VFPV3
#cmakedefine01 HAVE_VFP_ARGS
#cmakedefine01 HAVE_VSX
#cmakedefine01 HAVE_WINDOWS_H
#cmakedefine01 HAVE_WINRT
#cmakedefine01 HAVE_WINSOCK2_H
#cmakedefine01 HAVE_X86ASM
#cmakedefine01 HAVE_XFORM_ASM
#cmakedefine01 HAVE_XMM_CLOBBERS
#cmakedefine01 HAVE_XOP

// The remaining variables are assigned boolean values in the buildfile.
//
#cmakedefine01 HAVE_ALIGNED_STACK
#cmakedefine01 HAVE_ASM_MOD_Q
#cmakedefine01 HAVE_BCRYPT
#cmakedefine01 HAVE_CDIO_PARANOIA_H
#cmakedefine01 HAVE_CDIO_PARANOIA_PARANOIA_H
#cmakedefine01 HAVE_COMPILE_TIME_NAN
#cmakedefine01 HAVE_DEV_BKTR_IOCTL_BT848_H
#cmakedefine01 HAVE_DEV_BKTR_IOCTL_METEOR_H
#cmakedefine01 HAVE_DEV_IC_BT8XX_H
#cmakedefine01 HAVE_DEV_VIDEO_BKTR_IOCTL_BT848_H
#cmakedefine01 HAVE_DEV_VIDEO_METEOR_IOCTL_METEOR_H
#cmakedefine01 HAVE_DPI_AWARENESS_CONTEXT
#cmakedefine01 HAVE_ES2_GL_H
#cmakedefine01 HAVE_FAST_64BIT
#cmakedefine01 HAVE_GETMODULEHANDLE
#cmakedefine01 HAVE_GETPROCESSAFFINITYMASK
#cmakedefine01 HAVE_GETPROCESSMEMORYINFO
#cmakedefine01 HAVE_GETPROCESSTIMES
#cmakedefine01 HAVE_GETSTDHANDLE
#cmakedefine01 HAVE_GETSYSTEMTIMEASFILETIME
#cmakedefine01 HAVE_GLXGETPROCADDRESS
#cmakedefine01 HAVE_GSM_H
#cmakedefine01 HAVE_IDXGIOUTPUT5
#cmakedefine01 HAVE_IO_H
#cmakedefine01 HAVE_INTRINSICS_NEON
#cmakedefine01 HAVE_KBHIT
#cmakedefine01 HAVE_LIBDRM_GETFB2
#cmakedefine01 HAVE_MACHINE_IOCTL_BT848_H
#cmakedefine01 HAVE_MACHINE_IOCTL_METEOR_H
#cmakedefine01 HAVE_MALLOC_H
#cmakedefine01 HAVE_OPENCL
#cmakedefine01 HAVE_OPENCL_D3D11
#cmakedefine01 HAVE_OPENCL_DRM_ARM
#cmakedefine01 HAVE_OPENCL_DRM_BEIGNET
#cmakedefine01 HAVE_OPENCL_DXVA2
#cmakedefine01 HAVE_OPENCL_VAAPI_BEIGNET
#cmakedefine01 HAVE_OPENCL_VAAPI_INTEL_MEDIA
#cmakedefine01 HAVE_OPENCL_VIDEOTOOLBOX
#cmakedefine01 HAVE_OPENCV2_CORE_CORE_C_H
#cmakedefine01 HAVE_OPENGL_GL3_H
#cmakedefine01 HAVE_OPENVINO2
#cmakedefine01 HAVE_STRUCT_MFXCONFIGINTERFACE
#cmakedefine01 HAVE_VAAPI_DRM
#cmakedefine01 HAVE_VAAPI_WIN32
#cmakedefine01 HAVE_VAAPI_X11
#cmakedefine01 HAVE_VALGRIND_VALGRIND_H
#cmakedefine01 HAVE_VDPAU_X11
#cmakedefine01 HAVE_VIRTUALALLOC
#cmakedefine01 HAVE_W32THREADS
#cmakedefine01 HAVE_WGLGETPROCADDRESS
#cmakedefine01 HAVE_XMLLINT

// XXX_EXTERNAL & XXX_INLINE signals whether
// the assembly is built directly in the source,
// or if it's built as an assembly file (.asm/.S),
// and linked.

// 3DNow is a deprecated x86 extension so always disable it.
//
#define HAVE_AMD3DNOW 0
#define HAVE_AMD3DNOWEXT 0
#define HAVE_AMD3DNOWEXT_EXTERNAL 0
#define HAVE_AMD3DNOWEXT_INLINE 0
#define HAVE_AMD3DNOW_EXTERNAL 0
#define HAVE_AMD3DNOW_INLINE 0

// @@ TODO These are actually referenced in upstream code. If we're not going
//    to support MIPS then perhaps we should remove all references to it?
//
#define HAVE_MIPSFPU 0
//ignored: #undef HAVE_MIPS32R2
//ignored: #undef HAVE_MIPS32R5
//ignored: #undef HAVE_MIPS64R2
//ignored: #undef HAVE_MIPS32R6
//ignored: #undef HAVE_MIPS64R6
#define HAVE_MIPSDSP 0
//ignored: #undef HAVE_MIPSDSPR2

// AltiVec is PowerPC specific, not x86
#define HAVE_ALTIVEC_EXTERNAL HAVE_ALTIVEC
#define HAVE_ALTIVEC_INLINE (HAVE_ALTIVEC && HAVE_INLINE_ASM)

// ARM architectures
#define HAVE_ARMV5TE_EXTERNAL (HAVE_ARMV5TE && HAVE_ARM_ASM)
#define HAVE_ARMV5TE_INLINE (HAVE_ARMV5TE && HAVE_INLINE_ASM)
#define HAVE_ARMV6T2_EXTERNAL (HAVE_ARMV6T2 && HAVE_ARM_ASM)
#define HAVE_ARMV6T2_INLINE (HAVE_ARMV6T2 && HAVE_INLINE_ASM)
#define HAVE_ARMV6_EXTERNAL (HAVE_ARMV6 && HAVE_ARM_ASM)
#define HAVE_ARMV6_INLINE (HAVE_ARMV6 && HAVE_INLINE_ASM)
#define HAVE_ARMV8_EXTERNAL (HAVE_ARMV8 && HAVE_ARM_ASM)
#define HAVE_ARMV8_INLINE (HAVE_ARMV8 && HAVE_INLINE_ASM)

// x86/x64 specific architectures/instructions
#define HAVE_AVX2_EXTERNAL (HAVE_AVX2 && HAVE_X86ASM)
#define HAVE_AVX2_INLINE (HAVE_AVX2 && HAVE_INLINE_ASM)
#define HAVE_AVX512ICL_EXTERNAL (HAVE_AVX512ICL && HAVE_X86ASM)
#define HAVE_AVX512ICL_INLINE (HAVE_AVX512ICL && HAVE_INLINE_ASM)
#define HAVE_AVX512_EXTERNAL (HAVE_AVX512 && HAVE_X86ASM)
#define HAVE_AVX512_INLINE (HAVE_AVX512 && HAVE_INLINE_ASM)
#define HAVE_AVX_EXTERNAL (HAVE_AVX && HAVE_X86ASM)
#define HAVE_AVX_INLINE (HAVE_AVX && HAVE_INLINE_ASM)

// PowerPC specific, not x86
#define HAVE_DCBZL_EXTERNAL HAVE_DCBZL
#define HAVE_DCBZL_INLINE (HAVE_DCBZL && HAVE_INLINE_ASM)

// x86/x64 specific instructions
#define HAVE_FMA3_EXTERNAL (HAVE_FMA3 && HAVE_X86ASM)
#define HAVE_FMA3_INLINE (HAVE_FMA3 && HAVE_INLINE_ASM)
#define HAVE_FMA4_EXTERNAL (HAVE_FMA4 && HAVE_X86ASM)
#define HAVE_FMA4_INLINE (HAVE_FMA4 && HAVE_INLINE_ASM)
#define HAVE_I686_EXTERNAL (HAVE_I686 && HAVE_X86ASM)
#define HAVE_I686_INLINE (HAVE_I686 && HAVE_INLINE_ASM)
#define HAVE_I8MM_EXTERNAL (HAVE_I8MM && HAVE_X86ASM)
#define HAVE_I8MM_INLINE (HAVE_I8MM && HAVE_INLINE_ASM)

// Loongson (MIPS-like) architectures, not x86
#define HAVE_LASX_EXTERNAL HAVE_LASX
#define HAVE_LASX_INLINE (HAVE_LASX && HAVE_INLINE_ASM)
#define HAVE_LDBRX_EXTERNAL HAVE_LDBRX
#define HAVE_LDBRX_INLINE (HAVE_LDBRX && HAVE_INLINE_ASM)
#define HAVE_LOONGSON2_EXTERNAL HAVE_LOONGSON2
#define HAVE_LOONGSON2_INLINE (HAVE_LOONGSON2 && HAVE_INLINE_ASM)
#define HAVE_LOONGSON3_EXTERNAL HAVE_LOONGSON3
#define HAVE_LOONGSON3_INLINE (HAVE_LOONGSON3 && HAVE_INLINE_ASM)
#define HAVE_LSX_EXTERNAL HAVE_LSX
#define HAVE_LSX_INLINE (HAVE_LSX && HAVE_INLINE_ASM)

// MIPS architectures should use MIPS-specific assembly, not x86
// The following are ignored as per your note
#define HAVE_MMI_EXTERNAL HAVE_MMI
#define HAVE_MMI_INLINE (HAVE_MMI && HAVE_INLINE_ASM)

// x86/x64 specific instructions
#define HAVE_MMXEXT_EXTERNAL (HAVE_MMXEXT && HAVE_X86ASM)
#define HAVE_MMXEXT_INLINE (HAVE_MMXEXT && HAVE_INLINE_ASM)
#define HAVE_MMX_EXTERNAL (HAVE_MMX && HAVE_X86ASM)
#define HAVE_MMX_INLINE (HAVE_MMX && HAVE_INLINE_ASM)

// MIPS architectures should use MIPS-specific assembly, not x86
#define HAVE_MSA_EXTERNAL HAVE_MSA
#define HAVE_MSA_INLINE (HAVE_MSA && HAVE_INLINE_ASM)

// ARM architecture
#define HAVE_NEON_EXTERNAL (HAVE_NEON && HAVE_ARM_ASM)
#define HAVE_NEON_INLINE (HAVE_NEON && HAVE_INLINE_ASM)

// PowerPC specific, not x86
#define HAVE_PPC4XX_EXTERNAL HAVE_PPC4XX
#define HAVE_PPC4XX_INLINE (HAVE_PPC4XX && HAVE_INLINE_ASM)

// RISC-V specific, not x86
#define HAVE_RVV_EXTERNAL (HAVE_RVV && HAVE_RISCVASM)
#define HAVE_RVV_INLINE (HAVE_RVV && HAVE_INLINE_ASM)
#define HAVE_RV_EXTERNAL (HAVE_RV && HAVE_RISCVASM)
#define HAVE_RV_INLINE (HAVE_RV && HAVE_INLINE_ASM)

// x86/x64 specific instructions
#define HAVE_SSE2_EXTERNAL (HAVE_SSE2 && HAVE_X86ASM)
#define HAVE_SSE2_INLINE (HAVE_SSE2 && HAVE_INLINE_ASM)
#define HAVE_SSE3_EXTERNAL (HAVE_SSE3 && HAVE_X86ASM)
#define HAVE_SSE3_INLINE (HAVE_SSE3 && HAVE_INLINE_ASM)
//unused:  #define HAVE_SSE42_EXTERNAL (HAVE_SSE42 && HAVE_X86ASM)
//unused:  #define HAVE_SSE42_INLINE (HAVE_SSE42 && HAVE_INLINE_ASM)
#define HAVE_SSE4_EXTERNAL (HAVE_SSE4 && HAVE_X86ASM)
#define HAVE_SSE4_INLINE (HAVE_SSE4 && HAVE_INLINE_ASM)
#define HAVE_SSE_EXTERNAL (HAVE_SSE && HAVE_X86ASM)
#define HAVE_SSE_INLINE (HAVE_SSE && HAVE_INLINE_ASM)
#define HAVE_SSSE3_EXTERNAL (HAVE_SSSE3 && HAVE_X86ASM)
#define HAVE_SSSE3_INLINE (HAVE_SSSE3 && HAVE_INLINE_ASM)

// ARM architectures
#define HAVE_VFPV3_EXTERNAL (HAVE_VFPV3 && HAVE_ARM_ASM)
#define HAVE_VFPV3_INLINE (HAVE_VFPV3 && HAVE_INLINE_ASM)
#define HAVE_VFP_EXTERNAL (HAVE_VFP && HAVE_ARM_ASM)
#define HAVE_VFP_INLINE (HAVE_VFP && HAVE_INLINE_ASM)

// PowerPC specific, not x86
#define HAVE_VSX_EXTERNAL HAVE_VSX
#define HAVE_VSX_INLINE (HAVE_VSX && HAVE_INLINE_ASM)

// x86/x64 specific instructions
#define HAVE_XOP_EXTERNAL (HAVE_XOP && HAVE_X86ASM)
#define HAVE_XOP_INLINE (HAVE_XOP && HAVE_INLINE_ASM)

// Ignored Defines

#define HAVE_ARMV5TE 0
#define HAVE_ARMV6 0
#define HAVE_ARMV6T2 0
#define HAVE_CDIO_PARANOIA_PARANOIA_H 0

// FFmpeg specific checks & fallbacks
//
// #if !defined(HAVE_PTHREADS) && (defined(__MINGW32__) || defined(__CYGWIN__))
// #  define HAVE_PTHREADS 1
// #else
// #  define HAVE_PTHREADS 0
// #endif

#if HAVE_PTHREADS || HAVE_W32THREADS || HAVE_OS2THREADS
#  define HAVE_THREADS 1
#else
#  define HAVE_THREADS 0
#endif

// Project Configuration

// See README-DEV.md for why we don't use CONFIG_SHARED or CONFIG_STATIC.
// #define CONFIG_SHARED 0
// #define CONFIG_STATIC 0

#cmakedefine01 CONFIG_DOC
#cmakedefine01 CONFIG_HTMLPAGES
#cmakedefine01 CONFIG_MANPAGES
#cmakedefine01 CONFIG_PODPAGES
#cmakedefine01 CONFIG_TXTPAGES
#cmakedefine01 CONFIG_AVIO_HTTP_SERVE_FILES_EXAMPLE
#cmakedefine01 CONFIG_AVIO_LIST_DIR_EXAMPLE
#cmakedefine01 CONFIG_AVIO_READ_CALLBACK_EXAMPLE
#cmakedefine01 CONFIG_DECODE_AUDIO_EXAMPLE
#cmakedefine01 CONFIG_DECODE_FILTER_AUDIO_EXAMPLE
#cmakedefine01 CONFIG_DECODE_FILTER_VIDEO_EXAMPLE
#cmakedefine01 CONFIG_DECODE_VIDEO_EXAMPLE
#cmakedefine01 CONFIG_DEMUX_DECODE_EXAMPLE
#cmakedefine01 CONFIG_ENCODE_AUDIO_EXAMPLE
#cmakedefine01 CONFIG_ENCODE_VIDEO_EXAMPLE
#cmakedefine01 CONFIG_EXTRACT_MVS_EXAMPLE
#cmakedefine01 CONFIG_FILTER_AUDIO_EXAMPLE
#cmakedefine01 CONFIG_HW_DECODE_EXAMPLE
#cmakedefine01 CONFIG_MUX_EXAMPLE
#cmakedefine01 CONFIG_QSV_DECODE_EXAMPLE
#cmakedefine01 CONFIG_REMUX_EXAMPLE
#cmakedefine01 CONFIG_RESAMPLE_AUDIO_EXAMPLE
#cmakedefine01 CONFIG_SCALE_VIDEO_EXAMPLE
#cmakedefine01 CONFIG_SHOW_METADATA_EXAMPLE
#cmakedefine01 CONFIG_TRANSCODE_AAC_EXAMPLE
#cmakedefine01 CONFIG_TRANSCODE_EXAMPLE
#cmakedefine01 CONFIG_VAAPI_ENCODE_EXAMPLE
#cmakedefine01 CONFIG_VAAPI_TRANSCODE_EXAMPLE
#cmakedefine01 CONFIG_QSV_TRANSCODE_EXAMPLE
#cmakedefine01 CONFIG_AVISYNTH
#cmakedefine01 CONFIG_FREI0R
#cmakedefine01 CONFIG_LIBCDIO
#cmakedefine01 CONFIG_LIBDAVS2
#cmakedefine01 CONFIG_LIBDVDNAV
#cmakedefine01 CONFIG_LIBDVDREAD
#cmakedefine01 CONFIG_LIBRUBBERBAND
#cmakedefine01 CONFIG_LIBVIDSTAB
#cmakedefine01 CONFIG_LIBX264
#cmakedefine01 CONFIG_LIBX265
#cmakedefine01 CONFIG_LIBXAVS
#cmakedefine01 CONFIG_LIBXAVS2
#cmakedefine01 CONFIG_LIBXVID
#cmakedefine01 CONFIG_DECKLINK
#cmakedefine01 CONFIG_LIBFDK_AAC
#cmakedefine01 CONFIG_LIBTLS
#cmakedefine01 CONFIG_GMP
#cmakedefine01 CONFIG_LIBARIBB24
#cmakedefine01 CONFIG_LIBLENSFUN
#cmakedefine01 CONFIG_LIBOPENCORE_AMRNB
#cmakedefine01 CONFIG_LIBOPENCORE_AMRWB
#cmakedefine01 CONFIG_LIBVO_AMRWBENC
#cmakedefine01 CONFIG_MBEDTLS
#cmakedefine01 CONFIG_RKMPP
#cmakedefine01 CONFIG_LIBSMBCLIENT
#cmakedefine01 CONFIG_CHROMAPRINT
#cmakedefine01 CONFIG_GCRYPT
#cmakedefine01 CONFIG_GNUTLS
#cmakedefine01 CONFIG_JNI
#cmakedefine01 CONFIG_LADSPA
#cmakedefine01 CONFIG_LCMS2
#cmakedefine01 CONFIG_LIBAOM
#cmakedefine01 CONFIG_LIBARIBCAPTION
#cmakedefine01 CONFIG_LIBASS
#cmakedefine01 CONFIG_LIBBLURAY
#cmakedefine01 CONFIG_LIBBS2B
#cmakedefine01 CONFIG_LIBCACA
#cmakedefine01 CONFIG_LIBCELT
#cmakedefine01 CONFIG_LIBCODEC2
#cmakedefine01 CONFIG_LIBDAV1D
#cmakedefine01 CONFIG_LIBDC1394
#cmakedefine01 CONFIG_LIBFLITE
#cmakedefine01 CONFIG_LIBFONTCONFIG
#cmakedefine01 CONFIG_LIBFREETYPE
#cmakedefine01 CONFIG_LIBFRIBIDI
#cmakedefine01 CONFIG_LIBHARFBUZZ
#cmakedefine01 CONFIG_LIBGLSLANG
#cmakedefine01 CONFIG_LIBGME
#cmakedefine01 CONFIG_LIBGSM
#cmakedefine01 CONFIG_LIBIEC61883
#cmakedefine01 CONFIG_LIBILBC
#cmakedefine01 CONFIG_LIBJACK
#cmakedefine01 CONFIG_LIBJXL
#cmakedefine01 CONFIG_LIBKLVANC
#cmakedefine01 CONFIG_LIBKVAZAAR
#cmakedefine01 CONFIG_LIBMODPLUG
#cmakedefine01 CONFIG_LIBMP3LAME
#cmakedefine01 CONFIG_LIBMYSOFA
#cmakedefine01 CONFIG_LIBOPENCV
#cmakedefine01 CONFIG_LIBOPENH264
#cmakedefine01 CONFIG_LIBOPENJPEG
#cmakedefine01 CONFIG_LIBOPENMPT
#cmakedefine01 CONFIG_LIBOPENVINO
#cmakedefine01 CONFIG_LIBOPUS
#cmakedefine01 CONFIG_LIBPLACEBO
#cmakedefine01 CONFIG_LIBPULSE
#cmakedefine01 CONFIG_LIBQRENCODE
#cmakedefine01 CONFIG_LIBQUIRC
#cmakedefine01 CONFIG_LIBRABBITMQ
#cmakedefine01 CONFIG_LIBRAV1E
#cmakedefine01 CONFIG_LIBRIST
#cmakedefine01 CONFIG_LIBRSVG
#cmakedefine01 CONFIG_LIBRTMP
#cmakedefine01 CONFIG_LIBSHADERC
#cmakedefine01 CONFIG_LIBSHINE
#cmakedefine01 CONFIG_LIBSNAPPY
#cmakedefine01 CONFIG_LIBSOXR
#cmakedefine01 CONFIG_LIBSPEEX
#cmakedefine01 CONFIG_LIBSRT
#cmakedefine01 CONFIG_LIBSSH
#cmakedefine01 CONFIG_LIBSVTAV1
#cmakedefine01 CONFIG_LIBTENSORFLOW
#cmakedefine01 CONFIG_LIBTESSERACT
#cmakedefine01 CONFIG_LIBTHEORA
#cmakedefine01 CONFIG_LIBTORCH
#cmakedefine01 CONFIG_LIBTWOLAME
#cmakedefine01 CONFIG_LIBUAVS3D
#cmakedefine01 CONFIG_LIBV4L2
#cmakedefine01 CONFIG_LIBVMAF
#cmakedefine01 CONFIG_LIBVORBIS
#cmakedefine01 CONFIG_LIBVPX
#cmakedefine01 CONFIG_LIBWEBP
#cmakedefine01 CONFIG_LIBXEVD
#cmakedefine01 CONFIG_LIBXEVE
#cmakedefine01 CONFIG_LIBXML2
#cmakedefine01 CONFIG_LIBZIMG
#cmakedefine01 CONFIG_LIBZMQ
#cmakedefine01 CONFIG_LIBZVBI
#cmakedefine01 CONFIG_LV2
#cmakedefine01 CONFIG_MEDIACODEC
#cmakedefine01 CONFIG_OPENAL
#cmakedefine01 CONFIG_OPENGL
#cmakedefine01 CONFIG_OPENSSL
#cmakedefine01 CONFIG_POCKETSPHINX
#cmakedefine01 CONFIG_VAPOURSYNTH
#cmakedefine01 CONFIG_ALSA
#cmakedefine01 CONFIG_APPKIT
#cmakedefine01 CONFIG_AVFOUNDATION
#cmakedefine01 CONFIG_BZLIB
#cmakedefine01 CONFIG_COREIMAGE
#cmakedefine01 CONFIG_ICONV
#cmakedefine01 CONFIG_LIBXCB
#cmakedefine01 CONFIG_LIBXCB_SHM
#cmakedefine01 CONFIG_LIBXCB_SHAPE
#cmakedefine01 CONFIG_LIBXCB_XFIXES
#cmakedefine01 CONFIG_LZMA
#cmakedefine01 CONFIG_MEDIAFOUNDATION
#cmakedefine01 CONFIG_METAL
#cmakedefine01 CONFIG_SCHANNEL
#cmakedefine01 CONFIG_SDL2
#cmakedefine01 CONFIG_SECURETRANSPORT
#cmakedefine01 CONFIG_SNDIO
#cmakedefine01 CONFIG_XLIB
#cmakedefine01 CONFIG_ZLIB
#cmakedefine01 CONFIG_CUDA_NVCC
#cmakedefine01 CONFIG_CUDA_SDK
#cmakedefine01 CONFIG_LIBNPP
#cmakedefine01 CONFIG_LIBMFX
#cmakedefine01 CONFIG_LIBVPL
#cmakedefine01 CONFIG_MMAL
#cmakedefine01 CONFIG_OMX
#cmakedefine01 CONFIG_OPENCL
#cmakedefine01 CONFIG_AMF
#cmakedefine01 CONFIG_AUDIOTOOLBOX
#cmakedefine01 CONFIG_CUDA
#cmakedefine01 CONFIG_CUDA_LLVM
#cmakedefine01 CONFIG_CUVID
#cmakedefine01 CONFIG_D3D11VA
#cmakedefine01 CONFIG_D3D12VA
#cmakedefine01 CONFIG_DXVA2
#cmakedefine01 CONFIG_FFNVCODEC
#cmakedefine01 CONFIG_LIBDRM
#cmakedefine01 CONFIG_NVDEC
#cmakedefine01 CONFIG_NVENC
#cmakedefine01 CONFIG_VAAPI
#cmakedefine01 CONFIG_VDPAU
#cmakedefine01 CONFIG_VIDEOTOOLBOX
#cmakedefine01 CONFIG_VULKAN
#cmakedefine01 CONFIG_V4L2_M2M
#cmakedefine01 CONFIG_FTRAPV
#cmakedefine01 CONFIG_GRAY
#cmakedefine01 CONFIG_HARDCODED_TABLES
#cmakedefine01 CONFIG_OMX_RPI
#cmakedefine01 CONFIG_RUNTIME_CPUDETECT
#cmakedefine01 CONFIG_SAFE_BITSTREAM_READER
#cmakedefine01 CONFIG_SMALL
#cmakedefine01 CONFIG_SWSCALE_ALPHA
#cmakedefine01 CONFIG_GPL
#cmakedefine01 CONFIG_NONFREE
#cmakedefine01 CONFIG_VERSION3
#cmakedefine01 CONFIG_AVDEVICE
#cmakedefine01 CONFIG_AVFILTER
#cmakedefine01 CONFIG_SWSCALE
#cmakedefine01 CONFIG_POSTPROC
#cmakedefine01 CONFIG_AVFORMAT
#cmakedefine01 CONFIG_AVCODEC
#cmakedefine01 CONFIG_SWRESAMPLE
#cmakedefine01 CONFIG_AVUTIL
#cmakedefine01 CONFIG_FFPLAY
#cmakedefine01 CONFIG_FFPROBE
#cmakedefine01 CONFIG_FFMPEG
#cmakedefine01 CONFIG_DWT
#cmakedefine01 CONFIG_ERROR_RESILIENCE
#cmakedefine01 CONFIG_FAAN
#cmakedefine01 CONFIG_FAST_UNALIGNED
#cmakedefine01 CONFIG_LSP
#cmakedefine01 CONFIG_PIXELUTILS
#cmakedefine01 CONFIG_NETWORK
#cmakedefine01 CONFIG_AUTODETECT
#cmakedefine01 CONFIG_FONTCONFIG
#cmakedefine01 CONFIG_LARGE_TESTS
#cmakedefine01 CONFIG_LINUX_PERF
#cmakedefine01 CONFIG_MACOS_KPERF
#cmakedefine01 CONFIG_MEMORY_POISONING
#cmakedefine01 CONFIG_NEON_CLOBBER_TEST
#cmakedefine01 CONFIG_OSSFUZZ
#cmakedefine01 CONFIG_PTX_COMPRESSION
#cmakedefine01 CONFIG_THUMB
#cmakedefine01 CONFIG_VALGRIND_BACKTRACE
#cmakedefine01 CONFIG_XMM_CLOBBER_TEST
#cmakedefine01 CONFIG_BSFS
#cmakedefine01 CONFIG_DECODERS
#cmakedefine01 CONFIG_ENCODERS
#cmakedefine01 CONFIG_HWACCELS
#cmakedefine01 CONFIG_PARSERS
#cmakedefine01 CONFIG_INDEVS
#cmakedefine01 CONFIG_OUTDEVS
#cmakedefine01 CONFIG_FILTERS
#cmakedefine01 CONFIG_DEMUXERS
#cmakedefine01 CONFIG_MUXERS
#cmakedefine01 CONFIG_PROTOCOLS
#cmakedefine01 CONFIG_AANDCTTABLES
#cmakedefine01 CONFIG_AC3DSP
#cmakedefine01 CONFIG_ADTS_HEADER
#cmakedefine01 CONFIG_ATSC_A53
#cmakedefine01 CONFIG_AUDIO_FRAME_QUEUE
#cmakedefine01 CONFIG_AUDIODSP
#cmakedefine01 CONFIG_BLOCKDSP
#cmakedefine01 CONFIG_BSWAPDSP
#cmakedefine01 CONFIG_CABAC
#cmakedefine01 CONFIG_CBS
#cmakedefine01 CONFIG_CBS_AV1
#cmakedefine01 CONFIG_CBS_H264
#cmakedefine01 CONFIG_CBS_H265
#cmakedefine01 CONFIG_CBS_H266
#cmakedefine01 CONFIG_CBS_JPEG
#cmakedefine01 CONFIG_CBS_MPEG2
#cmakedefine01 CONFIG_CBS_VP8
#cmakedefine01 CONFIG_CBS_VP9
#cmakedefine01 CONFIG_DEFLATE_WRAPPER
#cmakedefine01 CONFIG_DIRAC_PARSE
#cmakedefine01 CONFIG_DNN
#cmakedefine01 CONFIG_DOVI_RPU
#cmakedefine01 CONFIG_DVPROFILE
#cmakedefine01 CONFIG_EVCPARSE
#cmakedefine01 CONFIG_EXIF
#cmakedefine01 CONFIG_FAANDCT
#cmakedefine01 CONFIG_FAANIDCT
#cmakedefine01 CONFIG_FDCTDSP
#cmakedefine01 CONFIG_FMTCONVERT
#cmakedefine01 CONFIG_FRAME_THREAD_ENCODER
#cmakedefine01 CONFIG_G722DSP
#cmakedefine01 CONFIG_GOLOMB
#cmakedefine01 CONFIG_GPLV3
#cmakedefine01 CONFIG_H263DSP
#cmakedefine01 CONFIG_H264CHROMA
#cmakedefine01 CONFIG_H264DSP
#cmakedefine01 CONFIG_H264PARSE
#cmakedefine01 CONFIG_H264PRED
#cmakedefine01 CONFIG_H264QPEL
#cmakedefine01 CONFIG_H264_SEI
#cmakedefine01 CONFIG_HEVCPARSE
#cmakedefine01 CONFIG_HEVC_SEI
#cmakedefine01 CONFIG_HPELDSP
#cmakedefine01 CONFIG_HUFFMAN
#cmakedefine01 CONFIG_HUFFYUVDSP
#cmakedefine01 CONFIG_HUFFYUVENCDSP
#cmakedefine01 CONFIG_IAMFDEC
#cmakedefine01 CONFIG_IAMFENC
#cmakedefine01 CONFIG_IDCTDSP
#cmakedefine01 CONFIG_IIRFILTER
#cmakedefine01 CONFIG_INFLATE_WRAPPER
#cmakedefine01 CONFIG_INTRAX8
#cmakedefine01 CONFIG_ISO_MEDIA
#cmakedefine01 CONFIG_IVIDSP
#cmakedefine01 CONFIG_JPEGTABLES
#cmakedefine01 CONFIG_LGPLV3
#cmakedefine01 CONFIG_LIBX262
#cmakedefine01 CONFIG_LIBX264_HDR10
#cmakedefine01 CONFIG_LLAUDDSP
#cmakedefine01 CONFIG_LLVIDDSP
#cmakedefine01 CONFIG_LLVIDENCDSP
#cmakedefine01 CONFIG_LPC
#cmakedefine01 CONFIG_LZF
#cmakedefine01 CONFIG_ME_CMP
#cmakedefine01 CONFIG_MPEG_ER
#cmakedefine01 CONFIG_MPEGAUDIO
#cmakedefine01 CONFIG_MPEGAUDIODSP
#cmakedefine01 CONFIG_MPEGAUDIOHEADER
#cmakedefine01 CONFIG_MPEG4AUDIO
#cmakedefine01 CONFIG_MPEGVIDEO
#cmakedefine01 CONFIG_MPEGVIDEODEC
#cmakedefine01 CONFIG_MPEGVIDEOENC
#cmakedefine01 CONFIG_MSMPEG4DEC
#cmakedefine01 CONFIG_MSMPEG4ENC
#cmakedefine01 CONFIG_MSS34DSP
#cmakedefine01 CONFIG_PIXBLOCKDSP
#cmakedefine01 CONFIG_QPELDSP
#cmakedefine01 CONFIG_QSV
#cmakedefine01 CONFIG_QSVDEC
#cmakedefine01 CONFIG_QSVENC
#cmakedefine01 CONFIG_QSVVPP
#cmakedefine01 CONFIG_RANGECODER
#cmakedefine01 CONFIG_RIFFDEC
#cmakedefine01 CONFIG_RIFFENC
#cmakedefine01 CONFIG_RTPDEC
#cmakedefine01 CONFIG_RTPENC_CHAIN
#cmakedefine01 CONFIG_RV34DSP
#cmakedefine01 CONFIG_SCENE_SAD
#cmakedefine01 CONFIG_SINEWIN
#cmakedefine01 CONFIG_SNAPPY
#cmakedefine01 CONFIG_SRTP
#cmakedefine01 CONFIG_STARTCODE
#cmakedefine01 CONFIG_TEXTUREDSP
#cmakedefine01 CONFIG_TEXTUREDSPENC
#cmakedefine01 CONFIG_TPELDSP
#cmakedefine01 CONFIG_VAAPI_1
#cmakedefine01 CONFIG_VAAPI_ENCODE
#cmakedefine01 CONFIG_VC1DSP
#cmakedefine01 CONFIG_VIDEODSP
#cmakedefine01 CONFIG_VP3DSP
#cmakedefine01 CONFIG_VP56DSP
#cmakedefine01 CONFIG_VP8DSP
#cmakedefine01 CONFIG_WMA_FREQS
#cmakedefine01 CONFIG_WMV2DSP

// config_components.h
#cmakedefine01 CONFIG_AAC_ADTSTOASC_BSF
#cmakedefine01 CONFIG_AV1_FRAME_MERGE_BSF
#cmakedefine01 CONFIG_AV1_FRAME_SPLIT_BSF
#cmakedefine01 CONFIG_AV1_METADATA_BSF
#cmakedefine01 CONFIG_CHOMP_BSF
#cmakedefine01 CONFIG_DUMP_EXTRADATA_BSF
#cmakedefine01 CONFIG_DCA_CORE_BSF
#cmakedefine01 CONFIG_DTS2PTS_BSF
#cmakedefine01 CONFIG_DV_ERROR_MARKER_BSF
#cmakedefine01 CONFIG_EAC3_CORE_BSF
#cmakedefine01 CONFIG_EXTRACT_EXTRADATA_BSF
#cmakedefine01 CONFIG_FILTER_UNITS_BSF
#cmakedefine01 CONFIG_H264_METADATA_BSF
#cmakedefine01 CONFIG_H264_MP4TOANNEXB_BSF
#cmakedefine01 CONFIG_H264_REDUNDANT_PPS_BSF
#cmakedefine01 CONFIG_HAPQA_EXTRACT_BSF
#cmakedefine01 CONFIG_HEVC_METADATA_BSF
#cmakedefine01 CONFIG_HEVC_MP4TOANNEXB_BSF
#cmakedefine01 CONFIG_IMX_DUMP_HEADER_BSF
#cmakedefine01 CONFIG_MEDIA100_TO_MJPEGB_BSF
#cmakedefine01 CONFIG_MJPEG2JPEG_BSF
#cmakedefine01 CONFIG_MJPEGA_DUMP_HEADER_BSF
#cmakedefine01 CONFIG_MPEG2_METADATA_BSF
#cmakedefine01 CONFIG_MPEG4_UNPACK_BFRAMES_BSF
#cmakedefine01 CONFIG_MOV2TEXTSUB_BSF
#cmakedefine01 CONFIG_NOISE_BSF
#cmakedefine01 CONFIG_NULL_BSF
#cmakedefine01 CONFIG_OPUS_METADATA_BSF
#cmakedefine01 CONFIG_PCM_RECHUNK_BSF
#cmakedefine01 CONFIG_PGS_FRAME_MERGE_BSF
#cmakedefine01 CONFIG_PRORES_METADATA_BSF
#cmakedefine01 CONFIG_REMOVE_EXTRADATA_BSF
#cmakedefine01 CONFIG_SETTS_BSF
#cmakedefine01 CONFIG_SHOWINFO_BSF
#cmakedefine01 CONFIG_TEXT2MOVSUB_BSF
#cmakedefine01 CONFIG_TRACE_HEADERS_BSF
#cmakedefine01 CONFIG_TRUEHD_CORE_BSF
#cmakedefine01 CONFIG_VP9_METADATA_BSF
#cmakedefine01 CONFIG_VP9_RAW_REORDER_BSF
#cmakedefine01 CONFIG_VP9_SUPERFRAME_BSF
#cmakedefine01 CONFIG_VP9_SUPERFRAME_SPLIT_BSF
#cmakedefine01 CONFIG_VVC_METADATA_BSF
#cmakedefine01 CONFIG_VVC_MP4TOANNEXB_BSF
#cmakedefine01 CONFIG_EVC_FRAME_MERGE_BSF
#cmakedefine01 CONFIG_AASC_DECODER
#cmakedefine01 CONFIG_AIC_DECODER
#cmakedefine01 CONFIG_ALIAS_PIX_DECODER
#cmakedefine01 CONFIG_AGM_DECODER
#cmakedefine01 CONFIG_AMV_DECODER
#cmakedefine01 CONFIG_ANM_DECODER
#cmakedefine01 CONFIG_ANSI_DECODER
#cmakedefine01 CONFIG_APNG_DECODER
#cmakedefine01 CONFIG_ARBC_DECODER
#cmakedefine01 CONFIG_ARGO_DECODER
#cmakedefine01 CONFIG_ASV1_DECODER
#cmakedefine01 CONFIG_ASV2_DECODER
#cmakedefine01 CONFIG_AURA_DECODER
#cmakedefine01 CONFIG_AURA2_DECODER
#cmakedefine01 CONFIG_AVRP_DECODER
#cmakedefine01 CONFIG_AVRN_DECODER
#cmakedefine01 CONFIG_AVS_DECODER
#cmakedefine01 CONFIG_AVUI_DECODER
#cmakedefine01 CONFIG_BETHSOFTVID_DECODER
#cmakedefine01 CONFIG_BFI_DECODER
#cmakedefine01 CONFIG_BINK_DECODER
#cmakedefine01 CONFIG_BITPACKED_DECODER
#cmakedefine01 CONFIG_BMP_DECODER
#cmakedefine01 CONFIG_BMV_VIDEO_DECODER
#cmakedefine01 CONFIG_BRENDER_PIX_DECODER
#cmakedefine01 CONFIG_C93_DECODER
#cmakedefine01 CONFIG_CAVS_DECODER
#cmakedefine01 CONFIG_CDGRAPHICS_DECODER
#cmakedefine01 CONFIG_CDTOONS_DECODER
#cmakedefine01 CONFIG_CDXL_DECODER
#cmakedefine01 CONFIG_CFHD_DECODER
#cmakedefine01 CONFIG_CINEPAK_DECODER
#cmakedefine01 CONFIG_CLEARVIDEO_DECODER
#cmakedefine01 CONFIG_CLJR_DECODER
#cmakedefine01 CONFIG_CLLC_DECODER
#cmakedefine01 CONFIG_COMFORTNOISE_DECODER
#cmakedefine01 CONFIG_CPIA_DECODER
#cmakedefine01 CONFIG_CRI_DECODER
#cmakedefine01 CONFIG_CSCD_DECODER
#cmakedefine01 CONFIG_CYUV_DECODER
#cmakedefine01 CONFIG_DDS_DECODER
#cmakedefine01 CONFIG_DFA_DECODER
#cmakedefine01 CONFIG_DIRAC_DECODER
#cmakedefine01 CONFIG_DNXHD_DECODER
#cmakedefine01 CONFIG_DPX_DECODER
#cmakedefine01 CONFIG_DSICINVIDEO_DECODER
#cmakedefine01 CONFIG_DVAUDIO_DECODER
#cmakedefine01 CONFIG_DVVIDEO_DECODER
#cmakedefine01 CONFIG_DXA_DECODER
#cmakedefine01 CONFIG_DXTORY_DECODER
#cmakedefine01 CONFIG_DXV_DECODER
#cmakedefine01 CONFIG_EACMV_DECODER
#cmakedefine01 CONFIG_EAMAD_DECODER
#cmakedefine01 CONFIG_EATGQ_DECODER
#cmakedefine01 CONFIG_EATGV_DECODER
#cmakedefine01 CONFIG_EATQI_DECODER
#cmakedefine01 CONFIG_EIGHTBPS_DECODER
#cmakedefine01 CONFIG_EIGHTSVX_EXP_DECODER
#cmakedefine01 CONFIG_EIGHTSVX_FIB_DECODER
#cmakedefine01 CONFIG_ESCAPE124_DECODER
#cmakedefine01 CONFIG_ESCAPE130_DECODER
#cmakedefine01 CONFIG_EXR_DECODER
#cmakedefine01 CONFIG_FFV1_DECODER
#cmakedefine01 CONFIG_FFVHUFF_DECODER
#cmakedefine01 CONFIG_FIC_DECODER
#cmakedefine01 CONFIG_FITS_DECODER
#cmakedefine01 CONFIG_FLASHSV_DECODER
#cmakedefine01 CONFIG_FLASHSV2_DECODER
#cmakedefine01 CONFIG_FLIC_DECODER
#cmakedefine01 CONFIG_FLV_DECODER
#cmakedefine01 CONFIG_FMVC_DECODER
#cmakedefine01 CONFIG_FOURXM_DECODER
#cmakedefine01 CONFIG_FRAPS_DECODER
#cmakedefine01 CONFIG_FRWU_DECODER
#cmakedefine01 CONFIG_G2M_DECODER
#cmakedefine01 CONFIG_GDV_DECODER
#cmakedefine01 CONFIG_GEM_DECODER
#cmakedefine01 CONFIG_GIF_DECODER
#cmakedefine01 CONFIG_H261_DECODER
#cmakedefine01 CONFIG_H263_DECODER
#cmakedefine01 CONFIG_H263I_DECODER
#cmakedefine01 CONFIG_H263P_DECODER
#cmakedefine01 CONFIG_H263_V4L2M2M_DECODER
#cmakedefine01 CONFIG_H264_DECODER
#cmakedefine01 CONFIG_H264_V4L2M2M_DECODER
#cmakedefine01 CONFIG_H264_MEDIACODEC_DECODER
#cmakedefine01 CONFIG_H264_MMAL_DECODER
#cmakedefine01 CONFIG_H264_QSV_DECODER
#cmakedefine01 CONFIG_H264_RKMPP_DECODER
#cmakedefine01 CONFIG_HAP_DECODER
#cmakedefine01 CONFIG_HEVC_DECODER
#cmakedefine01 CONFIG_HEVC_QSV_DECODER
#cmakedefine01 CONFIG_HEVC_RKMPP_DECODER
#cmakedefine01 CONFIG_HEVC_V4L2M2M_DECODER
#cmakedefine01 CONFIG_HNM4_VIDEO_DECODER
#cmakedefine01 CONFIG_HQ_HQA_DECODER
#cmakedefine01 CONFIG_HQX_DECODER
#cmakedefine01 CONFIG_HUFFYUV_DECODER
#cmakedefine01 CONFIG_HYMT_DECODER
#cmakedefine01 CONFIG_IDCIN_DECODER
#cmakedefine01 CONFIG_IFF_ILBM_DECODER
#cmakedefine01 CONFIG_IMM4_DECODER
#cmakedefine01 CONFIG_IMM5_DECODER
#cmakedefine01 CONFIG_INDEO2_DECODER
#cmakedefine01 CONFIG_INDEO3_DECODER
#cmakedefine01 CONFIG_INDEO4_DECODER
#cmakedefine01 CONFIG_INDEO5_DECODER
#cmakedefine01 CONFIG_INTERPLAY_VIDEO_DECODER
#cmakedefine01 CONFIG_IPU_DECODER
#cmakedefine01 CONFIG_JPEG2000_DECODER
#cmakedefine01 CONFIG_JPEGLS_DECODER
#cmakedefine01 CONFIG_JV_DECODER
#cmakedefine01 CONFIG_KGV1_DECODER
#cmakedefine01 CONFIG_KMVC_DECODER
#cmakedefine01 CONFIG_LAGARITH_DECODER
#cmakedefine01 CONFIG_LEAD_DECODER
#cmakedefine01 CONFIG_LOCO_DECODER
#cmakedefine01 CONFIG_LSCR_DECODER
#cmakedefine01 CONFIG_M101_DECODER
#cmakedefine01 CONFIG_MAGICYUV_DECODER
#cmakedefine01 CONFIG_MDEC_DECODER
#cmakedefine01 CONFIG_MEDIA100_DECODER
#cmakedefine01 CONFIG_MIMIC_DECODER
#cmakedefine01 CONFIG_MJPEG_DECODER
#cmakedefine01 CONFIG_MJPEGB_DECODER
#cmakedefine01 CONFIG_MMVIDEO_DECODER
#cmakedefine01 CONFIG_MOBICLIP_DECODER
#cmakedefine01 CONFIG_MOTIONPIXELS_DECODER
#cmakedefine01 CONFIG_MPEG1VIDEO_DECODER
#cmakedefine01 CONFIG_MPEG2VIDEO_DECODER
#cmakedefine01 CONFIG_MPEG4_DECODER
#cmakedefine01 CONFIG_MPEG4_V4L2M2M_DECODER
#cmakedefine01 CONFIG_MPEG4_MMAL_DECODER
#cmakedefine01 CONFIG_MPEGVIDEO_DECODER
#cmakedefine01 CONFIG_MPEG1_V4L2M2M_DECODER
#cmakedefine01 CONFIG_MPEG2_MMAL_DECODER
#cmakedefine01 CONFIG_MPEG2_V4L2M2M_DECODER
#cmakedefine01 CONFIG_MPEG2_QSV_DECODER
#cmakedefine01 CONFIG_MPEG2_MEDIACODEC_DECODER
#cmakedefine01 CONFIG_MSA1_DECODER
#cmakedefine01 CONFIG_MSCC_DECODER
#cmakedefine01 CONFIG_MSMPEG4V1_DECODER
#cmakedefine01 CONFIG_MSMPEG4V2_DECODER
#cmakedefine01 CONFIG_MSMPEG4V3_DECODER
#cmakedefine01 CONFIG_MSP2_DECODER
#cmakedefine01 CONFIG_MSRLE_DECODER
#cmakedefine01 CONFIG_MSS1_DECODER
#cmakedefine01 CONFIG_MSS2_DECODER
#cmakedefine01 CONFIG_MSVIDEO1_DECODER
#cmakedefine01 CONFIG_MSZH_DECODER
#cmakedefine01 CONFIG_MTS2_DECODER
#cmakedefine01 CONFIG_MV30_DECODER
#cmakedefine01 CONFIG_MVC1_DECODER
#cmakedefine01 CONFIG_MVC2_DECODER
#cmakedefine01 CONFIG_MVDV_DECODER
#cmakedefine01 CONFIG_MVHA_DECODER
#cmakedefine01 CONFIG_MWSC_DECODER
#cmakedefine01 CONFIG_MXPEG_DECODER
#cmakedefine01 CONFIG_NOTCHLC_DECODER
#cmakedefine01 CONFIG_NUV_DECODER
#cmakedefine01 CONFIG_PAF_VIDEO_DECODER
#cmakedefine01 CONFIG_PAM_DECODER
#cmakedefine01 CONFIG_PBM_DECODER
#cmakedefine01 CONFIG_PCX_DECODER
#cmakedefine01 CONFIG_PDV_DECODER
#cmakedefine01 CONFIG_PFM_DECODER
#cmakedefine01 CONFIG_PGM_DECODER
#cmakedefine01 CONFIG_PGMYUV_DECODER
#cmakedefine01 CONFIG_PGX_DECODER
#cmakedefine01 CONFIG_PHM_DECODER
#cmakedefine01 CONFIG_PHOTOCD_DECODER
#cmakedefine01 CONFIG_PICTOR_DECODER
#cmakedefine01 CONFIG_PIXLET_DECODER
#cmakedefine01 CONFIG_PNG_DECODER
#cmakedefine01 CONFIG_PPM_DECODER
#cmakedefine01 CONFIG_PRORES_DECODER
#cmakedefine01 CONFIG_PROSUMER_DECODER
#cmakedefine01 CONFIG_PSD_DECODER
#cmakedefine01 CONFIG_PTX_DECODER
#cmakedefine01 CONFIG_QDRAW_DECODER
#cmakedefine01 CONFIG_QOI_DECODER
#cmakedefine01 CONFIG_QPEG_DECODER
#cmakedefine01 CONFIG_QTRLE_DECODER
#cmakedefine01 CONFIG_R10K_DECODER
#cmakedefine01 CONFIG_R210_DECODER
#cmakedefine01 CONFIG_RASC_DECODER
#cmakedefine01 CONFIG_RAWVIDEO_DECODER
#cmakedefine01 CONFIG_RKA_DECODER
#cmakedefine01 CONFIG_RL2_DECODER
#cmakedefine01 CONFIG_ROQ_DECODER
#cmakedefine01 CONFIG_RPZA_DECODER
#cmakedefine01 CONFIG_RSCC_DECODER
#cmakedefine01 CONFIG_RTV1_DECODER
#cmakedefine01 CONFIG_RV10_DECODER
#cmakedefine01 CONFIG_RV20_DECODER
#cmakedefine01 CONFIG_RV30_DECODER
#cmakedefine01 CONFIG_RV40_DECODER
#cmakedefine01 CONFIG_S302M_DECODER
#cmakedefine01 CONFIG_SANM_DECODER
#cmakedefine01 CONFIG_SCPR_DECODER
#cmakedefine01 CONFIG_SCREENPRESSO_DECODER
#cmakedefine01 CONFIG_SGA_DECODER
#cmakedefine01 CONFIG_SGI_DECODER
#cmakedefine01 CONFIG_SGIRLE_DECODER
#cmakedefine01 CONFIG_SHEERVIDEO_DECODER
#cmakedefine01 CONFIG_SIMBIOSIS_IMX_DECODER
#cmakedefine01 CONFIG_SMACKER_DECODER
#cmakedefine01 CONFIG_SMC_DECODER
#cmakedefine01 CONFIG_SMVJPEG_DECODER
#cmakedefine01 CONFIG_SNOW_DECODER
#cmakedefine01 CONFIG_SP5X_DECODER
#cmakedefine01 CONFIG_SPEEDHQ_DECODER
#cmakedefine01 CONFIG_SPEEX_DECODER
#cmakedefine01 CONFIG_SRGC_DECODER
#cmakedefine01 CONFIG_SUNRAST_DECODER
#cmakedefine01 CONFIG_SVQ1_DECODER
#cmakedefine01 CONFIG_SVQ3_DECODER
#cmakedefine01 CONFIG_TARGA_DECODER
#cmakedefine01 CONFIG_TARGA_Y216_DECODER
#cmakedefine01 CONFIG_TDSC_DECODER
#cmakedefine01 CONFIG_THEORA_DECODER
#cmakedefine01 CONFIG_THP_DECODER
#cmakedefine01 CONFIG_TIERTEXSEQVIDEO_DECODER
#cmakedefine01 CONFIG_TIFF_DECODER
#cmakedefine01 CONFIG_TMV_DECODER
#cmakedefine01 CONFIG_TRUEMOTION1_DECODER
#cmakedefine01 CONFIG_TRUEMOTION2_DECODER
#cmakedefine01 CONFIG_TRUEMOTION2RT_DECODER
#cmakedefine01 CONFIG_TSCC_DECODER
#cmakedefine01 CONFIG_TSCC2_DECODER
#cmakedefine01 CONFIG_TXD_DECODER
#cmakedefine01 CONFIG_ULTI_DECODER
#cmakedefine01 CONFIG_UTVIDEO_DECODER
#cmakedefine01 CONFIG_V210_DECODER
#cmakedefine01 CONFIG_V210X_DECODER
#cmakedefine01 CONFIG_V308_DECODER
#cmakedefine01 CONFIG_V408_DECODER
#cmakedefine01 CONFIG_V410_DECODER
#cmakedefine01 CONFIG_VB_DECODER
#cmakedefine01 CONFIG_VBN_DECODER
#cmakedefine01 CONFIG_VBLE_DECODER
#cmakedefine01 CONFIG_VC1_DECODER
#cmakedefine01 CONFIG_VC1IMAGE_DECODER
#cmakedefine01 CONFIG_VC1_MMAL_DECODER
#cmakedefine01 CONFIG_VC1_QSV_DECODER
#cmakedefine01 CONFIG_VC1_V4L2M2M_DECODER
#cmakedefine01 CONFIG_VCR1_DECODER
#cmakedefine01 CONFIG_VMDVIDEO_DECODER
#cmakedefine01 CONFIG_VMIX_DECODER
#cmakedefine01 CONFIG_VMNC_DECODER
#cmakedefine01 CONFIG_VP3_DECODER
#cmakedefine01 CONFIG_VP4_DECODER
#cmakedefine01 CONFIG_VP5_DECODER
#cmakedefine01 CONFIG_VP6_DECODER
#cmakedefine01 CONFIG_VP6A_DECODER
#cmakedefine01 CONFIG_VP6F_DECODER
#cmakedefine01 CONFIG_VP7_DECODER
#cmakedefine01 CONFIG_VP8_DECODER
#cmakedefine01 CONFIG_VP8_RKMPP_DECODER
#cmakedefine01 CONFIG_VP8_V4L2M2M_DECODER
#cmakedefine01 CONFIG_VP9_DECODER
#cmakedefine01 CONFIG_VP9_RKMPP_DECODER
#cmakedefine01 CONFIG_VP9_V4L2M2M_DECODER
#cmakedefine01 CONFIG_VQA_DECODER
#cmakedefine01 CONFIG_VQC_DECODER
#cmakedefine01 CONFIG_VVC_DECODER
#cmakedefine01 CONFIG_WBMP_DECODER
#cmakedefine01 CONFIG_WEBP_DECODER
#cmakedefine01 CONFIG_WCMV_DECODER
#cmakedefine01 CONFIG_WRAPPED_AVFRAME_DECODER
#cmakedefine01 CONFIG_WMV1_DECODER
#cmakedefine01 CONFIG_WMV2_DECODER
#cmakedefine01 CONFIG_WMV3_DECODER
#cmakedefine01 CONFIG_WMV3IMAGE_DECODER
#cmakedefine01 CONFIG_WNV1_DECODER
#cmakedefine01 CONFIG_XAN_WC3_DECODER
#cmakedefine01 CONFIG_XAN_WC4_DECODER
#cmakedefine01 CONFIG_XBM_DECODER
#cmakedefine01 CONFIG_XFACE_DECODER
#cmakedefine01 CONFIG_XL_DECODER
#cmakedefine01 CONFIG_XPM_DECODER
#cmakedefine01 CONFIG_XWD_DECODER
#cmakedefine01 CONFIG_Y41P_DECODER
#cmakedefine01 CONFIG_YLC_DECODER
#cmakedefine01 CONFIG_YOP_DECODER
#cmakedefine01 CONFIG_YUV4_DECODER
#cmakedefine01 CONFIG_ZERO12V_DECODER
#cmakedefine01 CONFIG_ZEROCODEC_DECODER
#cmakedefine01 CONFIG_ZLIB_DECODER
#cmakedefine01 CONFIG_ZMBV_DECODER
#cmakedefine01 CONFIG_AAC_DECODER
#cmakedefine01 CONFIG_AAC_FIXED_DECODER
#cmakedefine01 CONFIG_AAC_LATM_DECODER
#cmakedefine01 CONFIG_AC3_DECODER
#cmakedefine01 CONFIG_AC3_FIXED_DECODER
#cmakedefine01 CONFIG_ACELP_KELVIN_DECODER
#cmakedefine01 CONFIG_ALAC_DECODER
#cmakedefine01 CONFIG_ALS_DECODER
#cmakedefine01 CONFIG_AMRNB_DECODER
#cmakedefine01 CONFIG_AMRWB_DECODER
#cmakedefine01 CONFIG_APAC_DECODER
#cmakedefine01 CONFIG_APE_DECODER
#cmakedefine01 CONFIG_APTX_DECODER
#cmakedefine01 CONFIG_APTX_HD_DECODER
#cmakedefine01 CONFIG_ATRAC1_DECODER
#cmakedefine01 CONFIG_ATRAC3_DECODER
#cmakedefine01 CONFIG_ATRAC3AL_DECODER
#cmakedefine01 CONFIG_ATRAC3P_DECODER
#cmakedefine01 CONFIG_ATRAC3PAL_DECODER
#cmakedefine01 CONFIG_ATRAC9_DECODER
#cmakedefine01 CONFIG_BINKAUDIO_DCT_DECODER
#cmakedefine01 CONFIG_BINKAUDIO_RDFT_DECODER
#cmakedefine01 CONFIG_BMV_AUDIO_DECODER
#cmakedefine01 CONFIG_BONK_DECODER
#cmakedefine01 CONFIG_COOK_DECODER
#cmakedefine01 CONFIG_DCA_DECODER
#cmakedefine01 CONFIG_DFPWM_DECODER
#cmakedefine01 CONFIG_DOLBY_E_DECODER
#cmakedefine01 CONFIG_DSD_LSBF_DECODER
#cmakedefine01 CONFIG_DSD_MSBF_DECODER
#cmakedefine01 CONFIG_DSD_LSBF_PLANAR_DECODER
#cmakedefine01 CONFIG_DSD_MSBF_PLANAR_DECODER
#cmakedefine01 CONFIG_DSICINAUDIO_DECODER
#cmakedefine01 CONFIG_DSS_SP_DECODER
#cmakedefine01 CONFIG_DST_DECODER
#cmakedefine01 CONFIG_EAC3_DECODER
#cmakedefine01 CONFIG_EVRC_DECODER
#cmakedefine01 CONFIG_FASTAUDIO_DECODER
#cmakedefine01 CONFIG_FFWAVESYNTH_DECODER
#cmakedefine01 CONFIG_FLAC_DECODER
#cmakedefine01 CONFIG_FTR_DECODER
#cmakedefine01 CONFIG_G723_1_DECODER
#cmakedefine01 CONFIG_G729_DECODER
#cmakedefine01 CONFIG_GSM_DECODER
#cmakedefine01 CONFIG_GSM_MS_DECODER
#cmakedefine01 CONFIG_HCA_DECODER
#cmakedefine01 CONFIG_HCOM_DECODER
#cmakedefine01 CONFIG_HDR_DECODER
#cmakedefine01 CONFIG_IAC_DECODER
#cmakedefine01 CONFIG_ILBC_DECODER
#cmakedefine01 CONFIG_IMC_DECODER
#cmakedefine01 CONFIG_INTERPLAY_ACM_DECODER
#cmakedefine01 CONFIG_MACE3_DECODER
#cmakedefine01 CONFIG_MACE6_DECODER
#cmakedefine01 CONFIG_METASOUND_DECODER
#cmakedefine01 CONFIG_MISC4_DECODER
#cmakedefine01 CONFIG_MLP_DECODER
#cmakedefine01 CONFIG_MP1_DECODER
#cmakedefine01 CONFIG_MP1FLOAT_DECODER
#cmakedefine01 CONFIG_MP2_DECODER
#cmakedefine01 CONFIG_MP2FLOAT_DECODER
#cmakedefine01 CONFIG_MP3FLOAT_DECODER
#cmakedefine01 CONFIG_MP3_DECODER
#cmakedefine01 CONFIG_MP3ADUFLOAT_DECODER
#cmakedefine01 CONFIG_MP3ADU_DECODER
#cmakedefine01 CONFIG_MP3ON4FLOAT_DECODER
#cmakedefine01 CONFIG_MP3ON4_DECODER
#cmakedefine01 CONFIG_MPC7_DECODER
#cmakedefine01 CONFIG_MPC8_DECODER
#cmakedefine01 CONFIG_MSNSIREN_DECODER
#cmakedefine01 CONFIG_NELLYMOSER_DECODER
#cmakedefine01 CONFIG_ON2AVC_DECODER
#cmakedefine01 CONFIG_OPUS_DECODER
#cmakedefine01 CONFIG_OSQ_DECODER
#cmakedefine01 CONFIG_PAF_AUDIO_DECODER
#cmakedefine01 CONFIG_QCELP_DECODER
#cmakedefine01 CONFIG_QDM2_DECODER
#cmakedefine01 CONFIG_QDMC_DECODER
#cmakedefine01 CONFIG_QOA_DECODER
#cmakedefine01 CONFIG_RA_144_DECODER
#cmakedefine01 CONFIG_RA_288_DECODER
#cmakedefine01 CONFIG_RALF_DECODER
#cmakedefine01 CONFIG_SBC_DECODER
#cmakedefine01 CONFIG_SHORTEN_DECODER
#cmakedefine01 CONFIG_SIPR_DECODER
#cmakedefine01 CONFIG_SIREN_DECODER
#cmakedefine01 CONFIG_SMACKAUD_DECODER
#cmakedefine01 CONFIG_SONIC_DECODER
#cmakedefine01 CONFIG_TAK_DECODER
#cmakedefine01 CONFIG_TRUEHD_DECODER
#cmakedefine01 CONFIG_TRUESPEECH_DECODER
#cmakedefine01 CONFIG_TTA_DECODER
#cmakedefine01 CONFIG_TWINVQ_DECODER
#cmakedefine01 CONFIG_VMDAUDIO_DECODER
#cmakedefine01 CONFIG_VORBIS_DECODER
#cmakedefine01 CONFIG_WAVARC_DECODER
#cmakedefine01 CONFIG_WAVPACK_DECODER
#cmakedefine01 CONFIG_WMALOSSLESS_DECODER
#cmakedefine01 CONFIG_WMAPRO_DECODER
#cmakedefine01 CONFIG_WMAV1_DECODER
#cmakedefine01 CONFIG_WMAV2_DECODER
#cmakedefine01 CONFIG_WMAVOICE_DECODER
#cmakedefine01 CONFIG_WS_SND1_DECODER
#cmakedefine01 CONFIG_XMA1_DECODER
#cmakedefine01 CONFIG_XMA2_DECODER
#cmakedefine01 CONFIG_PCM_ALAW_DECODER
#cmakedefine01 CONFIG_PCM_BLURAY_DECODER
#cmakedefine01 CONFIG_PCM_DVD_DECODER
#cmakedefine01 CONFIG_PCM_F16LE_DECODER
#cmakedefine01 CONFIG_PCM_F24LE_DECODER
#cmakedefine01 CONFIG_PCM_F32BE_DECODER
#cmakedefine01 CONFIG_PCM_F32LE_DECODER
#cmakedefine01 CONFIG_PCM_F64BE_DECODER
#cmakedefine01 CONFIG_PCM_F64LE_DECODER
#cmakedefine01 CONFIG_PCM_LXF_DECODER
#cmakedefine01 CONFIG_PCM_MULAW_DECODER
#cmakedefine01 CONFIG_PCM_S8_DECODER
#cmakedefine01 CONFIG_PCM_S8_PLANAR_DECODER
#cmakedefine01 CONFIG_PCM_S16BE_DECODER
#cmakedefine01 CONFIG_PCM_S16BE_PLANAR_DECODER
#cmakedefine01 CONFIG_PCM_S16LE_DECODER
#cmakedefine01 CONFIG_PCM_S16LE_PLANAR_DECODER
#cmakedefine01 CONFIG_PCM_S24BE_DECODER
#cmakedefine01 CONFIG_PCM_S24DAUD_DECODER
#cmakedefine01 CONFIG_PCM_S24LE_DECODER
#cmakedefine01 CONFIG_PCM_S24LE_PLANAR_DECODER
#cmakedefine01 CONFIG_PCM_S32BE_DECODER
#cmakedefine01 CONFIG_PCM_S32LE_DECODER
#cmakedefine01 CONFIG_PCM_S32LE_PLANAR_DECODER
#cmakedefine01 CONFIG_PCM_S64BE_DECODER
#cmakedefine01 CONFIG_PCM_S64LE_DECODER
#cmakedefine01 CONFIG_PCM_SGA_DECODER
#cmakedefine01 CONFIG_PCM_U8_DECODER
#cmakedefine01 CONFIG_PCM_U16BE_DECODER
#cmakedefine01 CONFIG_PCM_U16LE_DECODER
#cmakedefine01 CONFIG_PCM_U24BE_DECODER
#cmakedefine01 CONFIG_PCM_U24LE_DECODER
#cmakedefine01 CONFIG_PCM_U32BE_DECODER
#cmakedefine01 CONFIG_PCM_U32LE_DECODER
#cmakedefine01 CONFIG_PCM_VIDC_DECODER
#cmakedefine01 CONFIG_CBD2_DPCM_DECODER
#cmakedefine01 CONFIG_DERF_DPCM_DECODER
#cmakedefine01 CONFIG_GREMLIN_DPCM_DECODER
#cmakedefine01 CONFIG_INTERPLAY_DPCM_DECODER
#cmakedefine01 CONFIG_ROQ_DPCM_DECODER
#cmakedefine01 CONFIG_SDX2_DPCM_DECODER
#cmakedefine01 CONFIG_SOL_DPCM_DECODER
#cmakedefine01 CONFIG_XAN_DPCM_DECODER
#cmakedefine01 CONFIG_WADY_DPCM_DECODER
#cmakedefine01 CONFIG_ADPCM_4XM_DECODER
#cmakedefine01 CONFIG_ADPCM_ADX_DECODER
#cmakedefine01 CONFIG_ADPCM_AFC_DECODER
#cmakedefine01 CONFIG_ADPCM_AGM_DECODER
#cmakedefine01 CONFIG_ADPCM_AICA_DECODER
#cmakedefine01 CONFIG_ADPCM_ARGO_DECODER
#cmakedefine01 CONFIG_ADPCM_CT_DECODER
#cmakedefine01 CONFIG_ADPCM_DTK_DECODER
#cmakedefine01 CONFIG_ADPCM_EA_DECODER
#cmakedefine01 CONFIG_ADPCM_EA_MAXIS_XA_DECODER
#cmakedefine01 CONFIG_ADPCM_EA_R1_DECODER
#cmakedefine01 CONFIG_ADPCM_EA_R2_DECODER
#cmakedefine01 CONFIG_ADPCM_EA_R3_DECODER
#cmakedefine01 CONFIG_ADPCM_EA_XAS_DECODER
#cmakedefine01 CONFIG_ADPCM_G722_DECODER
#cmakedefine01 CONFIG_ADPCM_G726_DECODER
#cmakedefine01 CONFIG_ADPCM_G726LE_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_ACORN_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_AMV_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_ALP_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_APC_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_APM_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_CUNNING_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_DAT4_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_DK3_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_DK4_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_EA_EACS_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_EA_SEAD_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_ISS_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_MOFLEX_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_MTF_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_OKI_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_QT_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_RAD_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_SSI_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_SMJPEG_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_WAV_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_WS_DECODER
#cmakedefine01 CONFIG_ADPCM_MS_DECODER
#cmakedefine01 CONFIG_ADPCM_MTAF_DECODER
#cmakedefine01 CONFIG_ADPCM_PSX_DECODER
#cmakedefine01 CONFIG_ADPCM_SBPRO_2_DECODER
#cmakedefine01 CONFIG_ADPCM_SBPRO_3_DECODER
#cmakedefine01 CONFIG_ADPCM_SBPRO_4_DECODER
#cmakedefine01 CONFIG_ADPCM_SWF_DECODER
#cmakedefine01 CONFIG_ADPCM_THP_DECODER
#cmakedefine01 CONFIG_ADPCM_THP_LE_DECODER
#cmakedefine01 CONFIG_ADPCM_VIMA_DECODER
#cmakedefine01 CONFIG_ADPCM_XA_DECODER
#cmakedefine01 CONFIG_ADPCM_XMD_DECODER
#cmakedefine01 CONFIG_ADPCM_YAMAHA_DECODER
#cmakedefine01 CONFIG_ADPCM_ZORK_DECODER
#cmakedefine01 CONFIG_SSA_DECODER
#cmakedefine01 CONFIG_ASS_DECODER
#cmakedefine01 CONFIG_CCAPTION_DECODER
#cmakedefine01 CONFIG_DVBSUB_DECODER
#cmakedefine01 CONFIG_DVDSUB_DECODER
#cmakedefine01 CONFIG_JACOSUB_DECODER
#cmakedefine01 CONFIG_MICRODVD_DECODER
#cmakedefine01 CONFIG_MOVTEXT_DECODER
#cmakedefine01 CONFIG_MPL2_DECODER
#cmakedefine01 CONFIG_PGSSUB_DECODER
#cmakedefine01 CONFIG_PJS_DECODER
#cmakedefine01 CONFIG_REALTEXT_DECODER
#cmakedefine01 CONFIG_SAMI_DECODER
#cmakedefine01 CONFIG_SRT_DECODER
#cmakedefine01 CONFIG_STL_DECODER
#cmakedefine01 CONFIG_SUBRIP_DECODER
#cmakedefine01 CONFIG_SUBVIEWER_DECODER
#cmakedefine01 CONFIG_SUBVIEWER1_DECODER
#cmakedefine01 CONFIG_TEXT_DECODER
#cmakedefine01 CONFIG_VPLAYER_DECODER
#cmakedefine01 CONFIG_WEBVTT_DECODER
#cmakedefine01 CONFIG_XSUB_DECODER
#cmakedefine01 CONFIG_AAC_AT_DECODER
#cmakedefine01 CONFIG_AC3_AT_DECODER
#cmakedefine01 CONFIG_ADPCM_IMA_QT_AT_DECODER
#cmakedefine01 CONFIG_ALAC_AT_DECODER
#cmakedefine01 CONFIG_AMR_NB_AT_DECODER
#cmakedefine01 CONFIG_EAC3_AT_DECODER
#cmakedefine01 CONFIG_GSM_MS_AT_DECODER
#cmakedefine01 CONFIG_ILBC_AT_DECODER
#cmakedefine01 CONFIG_MP1_AT_DECODER
#cmakedefine01 CONFIG_MP2_AT_DECODER
#cmakedefine01 CONFIG_MP3_AT_DECODER
#cmakedefine01 CONFIG_PCM_ALAW_AT_DECODER
#cmakedefine01 CONFIG_PCM_MULAW_AT_DECODER
#cmakedefine01 CONFIG_QDMC_AT_DECODER
#cmakedefine01 CONFIG_QDM2_AT_DECODER
#cmakedefine01 CONFIG_LIBARIBCAPTION_DECODER
#cmakedefine01 CONFIG_LIBARIBB24_DECODER
#cmakedefine01 CONFIG_LIBCELT_DECODER
#cmakedefine01 CONFIG_LIBCODEC2_DECODER
#cmakedefine01 CONFIG_LIBDAV1D_DECODER
#cmakedefine01 CONFIG_LIBDAVS2_DECODER
#cmakedefine01 CONFIG_LIBFDK_AAC_DECODER
#cmakedefine01 CONFIG_LIBGSM_DECODER
#cmakedefine01 CONFIG_LIBGSM_MS_DECODER
#cmakedefine01 CONFIG_LIBILBC_DECODER
#cmakedefine01 CONFIG_LIBJXL_DECODER
#cmakedefine01 CONFIG_LIBOPENCORE_AMRNB_DECODER
#cmakedefine01 CONFIG_LIBOPENCORE_AMRWB_DECODER
#cmakedefine01 CONFIG_LIBOPUS_DECODER
#cmakedefine01 CONFIG_LIBRSVG_DECODER
#cmakedefine01 CONFIG_LIBSPEEX_DECODER
#cmakedefine01 CONFIG_LIBUAVS3D_DECODER
#cmakedefine01 CONFIG_LIBVORBIS_DECODER
#cmakedefine01 CONFIG_LIBVPX_VP8_DECODER
#cmakedefine01 CONFIG_LIBVPX_VP9_DECODER
#cmakedefine01 CONFIG_LIBXEVD_DECODER
#cmakedefine01 CONFIG_LIBZVBI_TELETEXT_DECODER
#cmakedefine01 CONFIG_BINTEXT_DECODER
#cmakedefine01 CONFIG_XBIN_DECODER
#cmakedefine01 CONFIG_IDF_DECODER
#cmakedefine01 CONFIG_LIBAOM_AV1_DECODER
#cmakedefine01 CONFIG_AV1_DECODER
#cmakedefine01 CONFIG_AV1_CUVID_DECODER
#cmakedefine01 CONFIG_AV1_MEDIACODEC_DECODER
#cmakedefine01 CONFIG_AV1_QSV_DECODER
#cmakedefine01 CONFIG_LIBOPENH264_DECODER
#cmakedefine01 CONFIG_H264_CUVID_DECODER
#cmakedefine01 CONFIG_HEVC_CUVID_DECODER
#cmakedefine01 CONFIG_HEVC_MEDIACODEC_DECODER
#cmakedefine01 CONFIG_MJPEG_CUVID_DECODER
#cmakedefine01 CONFIG_MJPEG_QSV_DECODER
#cmakedefine01 CONFIG_MPEG1_CUVID_DECODER
#cmakedefine01 CONFIG_MPEG2_CUVID_DECODER
#cmakedefine01 CONFIG_MPEG4_CUVID_DECODER
#cmakedefine01 CONFIG_MPEG4_MEDIACODEC_DECODER
#cmakedefine01 CONFIG_VC1_CUVID_DECODER
#cmakedefine01 CONFIG_VP8_CUVID_DECODER
#cmakedefine01 CONFIG_VP8_MEDIACODEC_DECODER
#cmakedefine01 CONFIG_VP8_QSV_DECODER
#cmakedefine01 CONFIG_VP9_CUVID_DECODER
#cmakedefine01 CONFIG_VP9_MEDIACODEC_DECODER
#cmakedefine01 CONFIG_VP9_QSV_DECODER
#cmakedefine01 CONFIG_VNULL_DECODER
#cmakedefine01 CONFIG_ANULL_DECODER
#cmakedefine01 CONFIG_A64MULTI_ENCODER
#cmakedefine01 CONFIG_A64MULTI5_ENCODER
#cmakedefine01 CONFIG_ALIAS_PIX_ENCODER
#cmakedefine01 CONFIG_AMV_ENCODER
#cmakedefine01 CONFIG_APNG_ENCODER
#cmakedefine01 CONFIG_ASV1_ENCODER
#cmakedefine01 CONFIG_ASV2_ENCODER
#cmakedefine01 CONFIG_AVRP_ENCODER
#cmakedefine01 CONFIG_AVUI_ENCODER
#cmakedefine01 CONFIG_BITPACKED_ENCODER
#cmakedefine01 CONFIG_BMP_ENCODER
#cmakedefine01 CONFIG_CFHD_ENCODER
#cmakedefine01 CONFIG_CINEPAK_ENCODER
#cmakedefine01 CONFIG_CLJR_ENCODER
#cmakedefine01 CONFIG_COMFORTNOISE_ENCODER
#cmakedefine01 CONFIG_DNXHD_ENCODER
#cmakedefine01 CONFIG_DPX_ENCODER
#cmakedefine01 CONFIG_DVVIDEO_ENCODER
#cmakedefine01 CONFIG_DXV_ENCODER
#cmakedefine01 CONFIG_EXR_ENCODER
#cmakedefine01 CONFIG_FFV1_ENCODER
#cmakedefine01 CONFIG_FFVHUFF_ENCODER
#cmakedefine01 CONFIG_FITS_ENCODER
#cmakedefine01 CONFIG_FLASHSV_ENCODER
#cmakedefine01 CONFIG_FLASHSV2_ENCODER
#cmakedefine01 CONFIG_FLV_ENCODER
#cmakedefine01 CONFIG_GIF_ENCODER
#cmakedefine01 CONFIG_H261_ENCODER
#cmakedefine01 CONFIG_H263_ENCODER
#cmakedefine01 CONFIG_H263P_ENCODER
#cmakedefine01 CONFIG_H264_MEDIACODEC_ENCODER
#cmakedefine01 CONFIG_HAP_ENCODER
#cmakedefine01 CONFIG_HUFFYUV_ENCODER
#cmakedefine01 CONFIG_JPEG2000_ENCODER
#cmakedefine01 CONFIG_JPEGLS_ENCODER
#cmakedefine01 CONFIG_LJPEG_ENCODER
#cmakedefine01 CONFIG_MAGICYUV_ENCODER
#cmakedefine01 CONFIG_MJPEG_ENCODER
#cmakedefine01 CONFIG_MPEG1VIDEO_ENCODER
#cmakedefine01 CONFIG_MPEG2VIDEO_ENCODER
#cmakedefine01 CONFIG_MPEG4_ENCODER
#cmakedefine01 CONFIG_MSMPEG4V2_ENCODER
#cmakedefine01 CONFIG_MSMPEG4V3_ENCODER
#cmakedefine01 CONFIG_MSRLE_ENCODER
#cmakedefine01 CONFIG_MSVIDEO1_ENCODER
#cmakedefine01 CONFIG_PAM_ENCODER
#cmakedefine01 CONFIG_PBM_ENCODER
#cmakedefine01 CONFIG_PCX_ENCODER
#cmakedefine01 CONFIG_PFM_ENCODER
#cmakedefine01 CONFIG_PGM_ENCODER
#cmakedefine01 CONFIG_PGMYUV_ENCODER
#cmakedefine01 CONFIG_PHM_ENCODER
#cmakedefine01 CONFIG_PNG_ENCODER
#cmakedefine01 CONFIG_PPM_ENCODER
#cmakedefine01 CONFIG_PRORES_ENCODER
#cmakedefine01 CONFIG_PRORES_AW_ENCODER
#cmakedefine01 CONFIG_PRORES_KS_ENCODER
#cmakedefine01 CONFIG_QOI_ENCODER
#cmakedefine01 CONFIG_QTRLE_ENCODER
#cmakedefine01 CONFIG_R10K_ENCODER
#cmakedefine01 CONFIG_R210_ENCODER
#cmakedefine01 CONFIG_RAWVIDEO_ENCODER
#cmakedefine01 CONFIG_ROQ_ENCODER
#cmakedefine01 CONFIG_RPZA_ENCODER
#cmakedefine01 CONFIG_RV10_ENCODER
#cmakedefine01 CONFIG_RV20_ENCODER
#cmakedefine01 CONFIG_S302M_ENCODER
#cmakedefine01 CONFIG_SGI_ENCODER
#cmakedefine01 CONFIG_SMC_ENCODER
#cmakedefine01 CONFIG_SNOW_ENCODER
#cmakedefine01 CONFIG_SPEEDHQ_ENCODER
#cmakedefine01 CONFIG_SUNRAST_ENCODER
#cmakedefine01 CONFIG_SVQ1_ENCODER
#cmakedefine01 CONFIG_TARGA_ENCODER
#cmakedefine01 CONFIG_TIFF_ENCODER
#cmakedefine01 CONFIG_UTVIDEO_ENCODER
#cmakedefine01 CONFIG_V210_ENCODER
#cmakedefine01 CONFIG_V308_ENCODER
#cmakedefine01 CONFIG_V408_ENCODER
#cmakedefine01 CONFIG_V410_ENCODER
#cmakedefine01 CONFIG_VBN_ENCODER
#cmakedefine01 CONFIG_VC2_ENCODER
#cmakedefine01 CONFIG_WBMP_ENCODER
#cmakedefine01 CONFIG_WRAPPED_AVFRAME_ENCODER
#cmakedefine01 CONFIG_WMV1_ENCODER
#cmakedefine01 CONFIG_WMV2_ENCODER
#cmakedefine01 CONFIG_XBM_ENCODER
#cmakedefine01 CONFIG_XFACE_ENCODER
#cmakedefine01 CONFIG_XWD_ENCODER
#cmakedefine01 CONFIG_Y41P_ENCODER
#cmakedefine01 CONFIG_YUV4_ENCODER
#cmakedefine01 CONFIG_ZLIB_ENCODER
#cmakedefine01 CONFIG_ZMBV_ENCODER
#cmakedefine01 CONFIG_AAC_ENCODER
#cmakedefine01 CONFIG_AC3_ENCODER
#cmakedefine01 CONFIG_AC3_FIXED_ENCODER
#cmakedefine01 CONFIG_ALAC_ENCODER
#cmakedefine01 CONFIG_APTX_ENCODER
#cmakedefine01 CONFIG_APTX_HD_ENCODER
#cmakedefine01 CONFIG_DCA_ENCODER
#cmakedefine01 CONFIG_DFPWM_ENCODER
#cmakedefine01 CONFIG_EAC3_ENCODER
#cmakedefine01 CONFIG_FLAC_ENCODER
#cmakedefine01 CONFIG_G723_1_ENCODER
#cmakedefine01 CONFIG_HDR_ENCODER
#cmakedefine01 CONFIG_MLP_ENCODER
#cmakedefine01 CONFIG_MP2_ENCODER
#cmakedefine01 CONFIG_MP2FIXED_ENCODER
#cmakedefine01 CONFIG_NELLYMOSER_ENCODER
#cmakedefine01 CONFIG_OPUS_ENCODER
#cmakedefine01 CONFIG_RA_144_ENCODER
#cmakedefine01 CONFIG_SBC_ENCODER
#cmakedefine01 CONFIG_SONIC_ENCODER
#cmakedefine01 CONFIG_SONIC_LS_ENCODER
#cmakedefine01 CONFIG_TRUEHD_ENCODER
#cmakedefine01 CONFIG_TTA_ENCODER
#cmakedefine01 CONFIG_VORBIS_ENCODER
#cmakedefine01 CONFIG_WAVPACK_ENCODER
#cmakedefine01 CONFIG_WMAV1_ENCODER
#cmakedefine01 CONFIG_WMAV2_ENCODER
#cmakedefine01 CONFIG_PCM_ALAW_ENCODER
#cmakedefine01 CONFIG_PCM_BLURAY_ENCODER
#cmakedefine01 CONFIG_PCM_DVD_ENCODER
#cmakedefine01 CONFIG_PCM_F32BE_ENCODER
#cmakedefine01 CONFIG_PCM_F32LE_ENCODER
#cmakedefine01 CONFIG_PCM_F64BE_ENCODER
#cmakedefine01 CONFIG_PCM_F64LE_ENCODER
#cmakedefine01 CONFIG_PCM_MULAW_ENCODER
#cmakedefine01 CONFIG_PCM_S8_ENCODER
#cmakedefine01 CONFIG_PCM_S8_PLANAR_ENCODER
#cmakedefine01 CONFIG_PCM_S16BE_ENCODER
#cmakedefine01 CONFIG_PCM_S16BE_PLANAR_ENCODER
#cmakedefine01 CONFIG_PCM_S16LE_ENCODER
#cmakedefine01 CONFIG_PCM_S16LE_PLANAR_ENCODER
#cmakedefine01 CONFIG_PCM_S24BE_ENCODER
#cmakedefine01 CONFIG_PCM_S24DAUD_ENCODER
#cmakedefine01 CONFIG_PCM_S24LE_ENCODER
#cmakedefine01 CONFIG_PCM_S24LE_PLANAR_ENCODER
#cmakedefine01 CONFIG_PCM_S32BE_ENCODER
#cmakedefine01 CONFIG_PCM_S32LE_ENCODER
#cmakedefine01 CONFIG_PCM_S32LE_PLANAR_ENCODER
#cmakedefine01 CONFIG_PCM_S64BE_ENCODER
#cmakedefine01 CONFIG_PCM_S64LE_ENCODER
#cmakedefine01 CONFIG_PCM_U8_ENCODER
#cmakedefine01 CONFIG_PCM_U16BE_ENCODER
#cmakedefine01 CONFIG_PCM_U16LE_ENCODER
#cmakedefine01 CONFIG_PCM_U24BE_ENCODER
#cmakedefine01 CONFIG_PCM_U24LE_ENCODER
#cmakedefine01 CONFIG_PCM_U32BE_ENCODER
#cmakedefine01 CONFIG_PCM_U32LE_ENCODER
#cmakedefine01 CONFIG_PCM_VIDC_ENCODER
#cmakedefine01 CONFIG_ROQ_DPCM_ENCODER
#cmakedefine01 CONFIG_ADPCM_ADX_ENCODER
#cmakedefine01 CONFIG_ADPCM_ARGO_ENCODER
#cmakedefine01 CONFIG_ADPCM_G722_ENCODER
#cmakedefine01 CONFIG_ADPCM_G726_ENCODER
#cmakedefine01 CONFIG_ADPCM_G726LE_ENCODER
#cmakedefine01 CONFIG_ADPCM_IMA_AMV_ENCODER
#cmakedefine01 CONFIG_ADPCM_IMA_ALP_ENCODER
#cmakedefine01 CONFIG_ADPCM_IMA_APM_ENCODER
#cmakedefine01 CONFIG_ADPCM_IMA_QT_ENCODER
#cmakedefine01 CONFIG_ADPCM_IMA_SSI_ENCODER
#cmakedefine01 CONFIG_ADPCM_IMA_WAV_ENCODER
#cmakedefine01 CONFIG_ADPCM_IMA_WS_ENCODER
#cmakedefine01 CONFIG_ADPCM_MS_ENCODER
#cmakedefine01 CONFIG_ADPCM_SWF_ENCODER
#cmakedefine01 CONFIG_ADPCM_YAMAHA_ENCODER
#cmakedefine01 CONFIG_SSA_ENCODER
#cmakedefine01 CONFIG_ASS_ENCODER
#cmakedefine01 CONFIG_DVBSUB_ENCODER
#cmakedefine01 CONFIG_DVDSUB_ENCODER
#cmakedefine01 CONFIG_MOVTEXT_ENCODER
#cmakedefine01 CONFIG_SRT_ENCODER
#cmakedefine01 CONFIG_SUBRIP_ENCODER
#cmakedefine01 CONFIG_TEXT_ENCODER
#cmakedefine01 CONFIG_TTML_ENCODER
#cmakedefine01 CONFIG_WEBVTT_ENCODER
#cmakedefine01 CONFIG_XSUB_ENCODER
#cmakedefine01 CONFIG_AAC_AT_ENCODER
#cmakedefine01 CONFIG_ALAC_AT_ENCODER
#cmakedefine01 CONFIG_ILBC_AT_ENCODER
#cmakedefine01 CONFIG_PCM_ALAW_AT_ENCODER
#cmakedefine01 CONFIG_PCM_MULAW_AT_ENCODER
#cmakedefine01 CONFIG_LIBAOM_AV1_ENCODER
#cmakedefine01 CONFIG_LIBCODEC2_ENCODER
#cmakedefine01 CONFIG_LIBFDK_AAC_ENCODER
#cmakedefine01 CONFIG_LIBGSM_ENCODER
#cmakedefine01 CONFIG_LIBGSM_MS_ENCODER
#cmakedefine01 CONFIG_LIBILBC_ENCODER
#cmakedefine01 CONFIG_LIBJXL_ENCODER
#cmakedefine01 CONFIG_LIBMP3LAME_ENCODER
#cmakedefine01 CONFIG_LIBOPENCORE_AMRNB_ENCODER
#cmakedefine01 CONFIG_LIBOPENJPEG_ENCODER
#cmakedefine01 CONFIG_LIBOPUS_ENCODER
#cmakedefine01 CONFIG_LIBRAV1E_ENCODER
#cmakedefine01 CONFIG_LIBSHINE_ENCODER
#cmakedefine01 CONFIG_LIBSPEEX_ENCODER
#cmakedefine01 CONFIG_LIBSVTAV1_ENCODER
#cmakedefine01 CONFIG_LIBTHEORA_ENCODER
#cmakedefine01 CONFIG_LIBTWOLAME_ENCODER
#cmakedefine01 CONFIG_LIBVO_AMRWBENC_ENCODER
#cmakedefine01 CONFIG_LIBVORBIS_ENCODER
#cmakedefine01 CONFIG_LIBVPX_VP8_ENCODER
#cmakedefine01 CONFIG_LIBVPX_VP9_ENCODER
#cmakedefine01 CONFIG_LIBWEBP_ANIM_ENCODER
#cmakedefine01 CONFIG_LIBWEBP_ENCODER
#cmakedefine01 CONFIG_LIBX262_ENCODER
#cmakedefine01 CONFIG_LIBX264_ENCODER
#cmakedefine01 CONFIG_LIBX264RGB_ENCODER
#cmakedefine01 CONFIG_LIBX265_ENCODER
#cmakedefine01 CONFIG_LIBXEVE_ENCODER
#cmakedefine01 CONFIG_LIBXAVS_ENCODER
#cmakedefine01 CONFIG_LIBXAVS2_ENCODER
#cmakedefine01 CONFIG_LIBXVID_ENCODER
#cmakedefine01 CONFIG_AAC_MF_ENCODER
#cmakedefine01 CONFIG_AC3_MF_ENCODER
#cmakedefine01 CONFIG_H263_V4L2M2M_ENCODER
#cmakedefine01 CONFIG_AV1_MEDIACODEC_ENCODER
#cmakedefine01 CONFIG_AV1_NVENC_ENCODER
#cmakedefine01 CONFIG_AV1_QSV_ENCODER
#cmakedefine01 CONFIG_AV1_AMF_ENCODER
#cmakedefine01 CONFIG_AV1_VAAPI_ENCODER
#cmakedefine01 CONFIG_LIBOPENH264_ENCODER
#cmakedefine01 CONFIG_H264_AMF_ENCODER
#cmakedefine01 CONFIG_H264_MF_ENCODER
#cmakedefine01 CONFIG_H264_NVENC_ENCODER
#cmakedefine01 CONFIG_H264_OMX_ENCODER
#cmakedefine01 CONFIG_H264_QSV_ENCODER
#cmakedefine01 CONFIG_H264_V4L2M2M_ENCODER
#cmakedefine01 CONFIG_H264_VAAPI_ENCODER
#cmakedefine01 CONFIG_H264_VIDEOTOOLBOX_ENCODER
#cmakedefine01 CONFIG_HEVC_AMF_ENCODER
#cmakedefine01 CONFIG_HEVC_MEDIACODEC_ENCODER
#cmakedefine01 CONFIG_HEVC_MF_ENCODER
#cmakedefine01 CONFIG_HEVC_NVENC_ENCODER
#cmakedefine01 CONFIG_HEVC_QSV_ENCODER
#cmakedefine01 CONFIG_HEVC_V4L2M2M_ENCODER
#cmakedefine01 CONFIG_HEVC_VAAPI_ENCODER
#cmakedefine01 CONFIG_HEVC_VIDEOTOOLBOX_ENCODER
#cmakedefine01 CONFIG_LIBKVAZAAR_ENCODER
#cmakedefine01 CONFIG_MJPEG_QSV_ENCODER
#cmakedefine01 CONFIG_MJPEG_VAAPI_ENCODER
#cmakedefine01 CONFIG_MP3_MF_ENCODER
#cmakedefine01 CONFIG_MPEG2_QSV_ENCODER
#cmakedefine01 CONFIG_MPEG2_VAAPI_ENCODER
#cmakedefine01 CONFIG_MPEG4_MEDIACODEC_ENCODER
#cmakedefine01 CONFIG_MPEG4_OMX_ENCODER
#cmakedefine01 CONFIG_MPEG4_V4L2M2M_ENCODER
#cmakedefine01 CONFIG_PRORES_VIDEOTOOLBOX_ENCODER
#cmakedefine01 CONFIG_VP8_MEDIACODEC_ENCODER
#cmakedefine01 CONFIG_VP8_V4L2M2M_ENCODER
#cmakedefine01 CONFIG_VP8_VAAPI_ENCODER
#cmakedefine01 CONFIG_VP9_MEDIACODEC_ENCODER
#cmakedefine01 CONFIG_VP9_VAAPI_ENCODER
#cmakedefine01 CONFIG_VP9_QSV_ENCODER
#cmakedefine01 CONFIG_VNULL_ENCODER
#cmakedefine01 CONFIG_ANULL_ENCODER
#cmakedefine01 CONFIG_AV1_D3D11VA_HWACCEL
#cmakedefine01 CONFIG_AV1_D3D11VA2_HWACCEL
#cmakedefine01 CONFIG_AV1_D3D12VA_HWACCEL
#cmakedefine01 CONFIG_AV1_DXVA2_HWACCEL
#cmakedefine01 CONFIG_AV1_NVDEC_HWACCEL
#cmakedefine01 CONFIG_AV1_VAAPI_HWACCEL
#cmakedefine01 CONFIG_AV1_VDPAU_HWACCEL
#cmakedefine01 CONFIG_AV1_VULKAN_HWACCEL
#cmakedefine01 CONFIG_H263_VAAPI_HWACCEL
#cmakedefine01 CONFIG_H263_VIDEOTOOLBOX_HWACCEL
#cmakedefine01 CONFIG_H264_D3D11VA_HWACCEL
#cmakedefine01 CONFIG_H264_D3D11VA2_HWACCEL
#cmakedefine01 CONFIG_H264_D3D12VA_HWACCEL
#cmakedefine01 CONFIG_H264_DXVA2_HWACCEL
#cmakedefine01 CONFIG_H264_NVDEC_HWACCEL
#cmakedefine01 CONFIG_H264_VAAPI_HWACCEL
#cmakedefine01 CONFIG_H264_VDPAU_HWACCEL
#cmakedefine01 CONFIG_H264_VIDEOTOOLBOX_HWACCEL
#cmakedefine01 CONFIG_H264_VULKAN_HWACCEL
#cmakedefine01 CONFIG_HEVC_D3D11VA_HWACCEL
#cmakedefine01 CONFIG_HEVC_D3D11VA2_HWACCEL
#cmakedefine01 CONFIG_HEVC_D3D12VA_HWACCEL
#cmakedefine01 CONFIG_HEVC_DXVA2_HWACCEL
#cmakedefine01 CONFIG_HEVC_NVDEC_HWACCEL
#cmakedefine01 CONFIG_HEVC_VAAPI_HWACCEL
#cmakedefine01 CONFIG_HEVC_VDPAU_HWACCEL
#cmakedefine01 CONFIG_HEVC_VIDEOTOOLBOX_HWACCEL
#cmakedefine01 CONFIG_HEVC_VULKAN_HWACCEL
#cmakedefine01 CONFIG_MJPEG_NVDEC_HWACCEL
#cmakedefine01 CONFIG_MJPEG_VAAPI_HWACCEL
#cmakedefine01 CONFIG_MPEG1_NVDEC_HWACCEL
#cmakedefine01 CONFIG_MPEG1_VDPAU_HWACCEL
#cmakedefine01 CONFIG_MPEG1_VIDEOTOOLBOX_HWACCEL
#cmakedefine01 CONFIG_MPEG2_D3D11VA_HWACCEL
#cmakedefine01 CONFIG_MPEG2_D3D11VA2_HWACCEL
#cmakedefine01 CONFIG_MPEG2_D3D12VA_HWACCEL
#cmakedefine01 CONFIG_MPEG2_DXVA2_HWACCEL
#cmakedefine01 CONFIG_MPEG2_NVDEC_HWACCEL
#cmakedefine01 CONFIG_MPEG2_VAAPI_HWACCEL
#cmakedefine01 CONFIG_MPEG2_VDPAU_HWACCEL
#cmakedefine01 CONFIG_MPEG2_VIDEOTOOLBOX_HWACCEL
#cmakedefine01 CONFIG_MPEG4_NVDEC_HWACCEL
#cmakedefine01 CONFIG_MPEG4_VAAPI_HWACCEL
#cmakedefine01 CONFIG_MPEG4_VDPAU_HWACCEL
#cmakedefine01 CONFIG_MPEG4_VIDEOTOOLBOX_HWACCEL
#cmakedefine01 CONFIG_PRORES_VIDEOTOOLBOX_HWACCEL
#cmakedefine01 CONFIG_VC1_D3D11VA_HWACCEL
#cmakedefine01 CONFIG_VC1_D3D11VA2_HWACCEL
#cmakedefine01 CONFIG_VC1_D3D12VA_HWACCEL
#cmakedefine01 CONFIG_VC1_DXVA2_HWACCEL
#cmakedefine01 CONFIG_VC1_NVDEC_HWACCEL
#cmakedefine01 CONFIG_VC1_VAAPI_HWACCEL
#cmakedefine01 CONFIG_VC1_VDPAU_HWACCEL
#cmakedefine01 CONFIG_VP8_NVDEC_HWACCEL
#cmakedefine01 CONFIG_VP8_VAAPI_HWACCEL
#cmakedefine01 CONFIG_VP9_D3D11VA_HWACCEL
#cmakedefine01 CONFIG_VP9_D3D11VA2_HWACCEL
#cmakedefine01 CONFIG_VP9_D3D12VA_HWACCEL
#cmakedefine01 CONFIG_VP9_DXVA2_HWACCEL
#cmakedefine01 CONFIG_VP9_NVDEC_HWACCEL
#cmakedefine01 CONFIG_VP9_VAAPI_HWACCEL
#cmakedefine01 CONFIG_VP9_VDPAU_HWACCEL
#cmakedefine01 CONFIG_VP9_VIDEOTOOLBOX_HWACCEL
#cmakedefine01 CONFIG_WMV3_D3D11VA_HWACCEL
#cmakedefine01 CONFIG_WMV3_D3D11VA2_HWACCEL
#cmakedefine01 CONFIG_WMV3_D3D12VA_HWACCEL
#cmakedefine01 CONFIG_WMV3_DXVA2_HWACCEL
#cmakedefine01 CONFIG_WMV3_NVDEC_HWACCEL
#cmakedefine01 CONFIG_WMV3_VAAPI_HWACCEL
#cmakedefine01 CONFIG_WMV3_VDPAU_HWACCEL
#cmakedefine01 CONFIG_AAC_PARSER
#cmakedefine01 CONFIG_AAC_LATM_PARSER
#cmakedefine01 CONFIG_AC3_PARSER
#cmakedefine01 CONFIG_ADX_PARSER
#cmakedefine01 CONFIG_AMR_PARSER
#cmakedefine01 CONFIG_AV1_PARSER
#cmakedefine01 CONFIG_AVS2_PARSER
#cmakedefine01 CONFIG_AVS3_PARSER
#cmakedefine01 CONFIG_BMP_PARSER
#cmakedefine01 CONFIG_CAVSVIDEO_PARSER
#cmakedefine01 CONFIG_COOK_PARSER
#cmakedefine01 CONFIG_CRI_PARSER
#cmakedefine01 CONFIG_DCA_PARSER
#cmakedefine01 CONFIG_DIRAC_PARSER
#cmakedefine01 CONFIG_DNXHD_PARSER
#cmakedefine01 CONFIG_DOLBY_E_PARSER
#cmakedefine01 CONFIG_DPX_PARSER
#cmakedefine01 CONFIG_DVAUDIO_PARSER
#cmakedefine01 CONFIG_DVBSUB_PARSER
#cmakedefine01 CONFIG_DVDSUB_PARSER
#cmakedefine01 CONFIG_DVD_NAV_PARSER
#cmakedefine01 CONFIG_EVC_PARSER
#cmakedefine01 CONFIG_FLAC_PARSER
#cmakedefine01 CONFIG_FTR_PARSER
#cmakedefine01 CONFIG_G723_1_PARSER
#cmakedefine01 CONFIG_G729_PARSER
#cmakedefine01 CONFIG_GIF_PARSER
#cmakedefine01 CONFIG_GSM_PARSER
#cmakedefine01 CONFIG_H261_PARSER
#cmakedefine01 CONFIG_H263_PARSER
#cmakedefine01 CONFIG_H264_PARSER
#cmakedefine01 CONFIG_HEVC_PARSER
#cmakedefine01 CONFIG_HDR_PARSER
#cmakedefine01 CONFIG_IPU_PARSER
#cmakedefine01 CONFIG_JPEG2000_PARSER
#cmakedefine01 CONFIG_JPEGXL_PARSER
#cmakedefine01 CONFIG_MISC4_PARSER
#cmakedefine01 CONFIG_MJPEG_PARSER
#cmakedefine01 CONFIG_MLP_PARSER
#cmakedefine01 CONFIG_MPEG4VIDEO_PARSER
#cmakedefine01 CONFIG_MPEGAUDIO_PARSER
#cmakedefine01 CONFIG_MPEGVIDEO_PARSER
#cmakedefine01 CONFIG_OPUS_PARSER
#cmakedefine01 CONFIG_PNG_PARSER
#cmakedefine01 CONFIG_PNM_PARSER
#cmakedefine01 CONFIG_QOI_PARSER
#cmakedefine01 CONFIG_RV34_PARSER
#cmakedefine01 CONFIG_SBC_PARSER
#cmakedefine01 CONFIG_SIPR_PARSER
#cmakedefine01 CONFIG_TAK_PARSER
#cmakedefine01 CONFIG_VC1_PARSER
#cmakedefine01 CONFIG_VORBIS_PARSER
#cmakedefine01 CONFIG_VP3_PARSER
#cmakedefine01 CONFIG_VP8_PARSER
#cmakedefine01 CONFIG_VP9_PARSER
#cmakedefine01 CONFIG_VVC_PARSER
#cmakedefine01 CONFIG_WEBP_PARSER
#cmakedefine01 CONFIG_XBM_PARSER
#cmakedefine01 CONFIG_XMA_PARSER
#cmakedefine01 CONFIG_XWD_PARSER
#cmakedefine01 CONFIG_ALSA_INDEV
#cmakedefine01 CONFIG_ANDROID_CAMERA_INDEV
#cmakedefine01 CONFIG_AVFOUNDATION_INDEV
#cmakedefine01 CONFIG_BKTR_INDEV
#cmakedefine01 CONFIG_DECKLINK_INDEV
#cmakedefine01 CONFIG_DSHOW_INDEV
#cmakedefine01 CONFIG_FBDEV_INDEV
#cmakedefine01 CONFIG_GDIGRAB_INDEV
#cmakedefine01 CONFIG_IEC61883_INDEV
#cmakedefine01 CONFIG_JACK_INDEV
#cmakedefine01 CONFIG_KMSGRAB_INDEV
#cmakedefine01 CONFIG_LAVFI_INDEV
#cmakedefine01 CONFIG_OPENAL_INDEV
#cmakedefine01 CONFIG_OSS_INDEV
#cmakedefine01 CONFIG_PULSE_INDEV
#cmakedefine01 CONFIG_SNDIO_INDEV
#cmakedefine01 CONFIG_V4L2_INDEV
#cmakedefine01 CONFIG_VFWCAP_INDEV
#cmakedefine01 CONFIG_XCBGRAB_INDEV
#cmakedefine01 CONFIG_LIBCDIO_INDEV
#cmakedefine01 CONFIG_LIBDC1394_INDEV
#cmakedefine01 CONFIG_ALSA_OUTDEV
#cmakedefine01 CONFIG_AUDIOTOOLBOX_OUTDEV
#cmakedefine01 CONFIG_CACA_OUTDEV
#cmakedefine01 CONFIG_DECKLINK_OUTDEV
#cmakedefine01 CONFIG_FBDEV_OUTDEV
#cmakedefine01 CONFIG_OPENGL_OUTDEV
#cmakedefine01 CONFIG_OSS_OUTDEV
#cmakedefine01 CONFIG_PULSE_OUTDEV
#cmakedefine01 CONFIG_SDL2_OUTDEV
#cmakedefine01 CONFIG_SNDIO_OUTDEV
#cmakedefine01 CONFIG_V4L2_OUTDEV
#cmakedefine01 CONFIG_XV_OUTDEV
#cmakedefine01 CONFIG_AAP_FILTER
#cmakedefine01 CONFIG_ABENCH_FILTER
#cmakedefine01 CONFIG_ACOMPRESSOR_FILTER
#cmakedefine01 CONFIG_ACONTRAST_FILTER
#cmakedefine01 CONFIG_ACOPY_FILTER
#cmakedefine01 CONFIG_ACUE_FILTER
#cmakedefine01 CONFIG_ACROSSFADE_FILTER
#cmakedefine01 CONFIG_ACROSSOVER_FILTER
#cmakedefine01 CONFIG_ACRUSHER_FILTER
#cmakedefine01 CONFIG_ADECLICK_FILTER
#cmakedefine01 CONFIG_ADECLIP_FILTER
#cmakedefine01 CONFIG_ADECORRELATE_FILTER
#cmakedefine01 CONFIG_ADELAY_FILTER
#cmakedefine01 CONFIG_ADENORM_FILTER
#cmakedefine01 CONFIG_ADERIVATIVE_FILTER
#cmakedefine01 CONFIG_ADRC_FILTER
#cmakedefine01 CONFIG_ADYNAMICEQUALIZER_FILTER
#cmakedefine01 CONFIG_ADYNAMICSMOOTH_FILTER
#cmakedefine01 CONFIG_AECHO_FILTER
#cmakedefine01 CONFIG_AEMPHASIS_FILTER
#cmakedefine01 CONFIG_AEVAL_FILTER
#cmakedefine01 CONFIG_AEXCITER_FILTER
#cmakedefine01 CONFIG_AFADE_FILTER
#cmakedefine01 CONFIG_AFFTDN_FILTER
#cmakedefine01 CONFIG_AFFTFILT_FILTER
#cmakedefine01 CONFIG_AFIR_FILTER
#cmakedefine01 CONFIG_AFORMAT_FILTER
#cmakedefine01 CONFIG_AFREQSHIFT_FILTER
#cmakedefine01 CONFIG_AFWTDN_FILTER
#cmakedefine01 CONFIG_AGATE_FILTER
#cmakedefine01 CONFIG_AIIR_FILTER
#cmakedefine01 CONFIG_AINTEGRAL_FILTER
#cmakedefine01 CONFIG_AINTERLEAVE_FILTER
#cmakedefine01 CONFIG_ALATENCY_FILTER
#cmakedefine01 CONFIG_ALIMITER_FILTER
#cmakedefine01 CONFIG_ALLPASS_FILTER
#cmakedefine01 CONFIG_ALOOP_FILTER
#cmakedefine01 CONFIG_AMERGE_FILTER
#cmakedefine01 CONFIG_AMETADATA_FILTER
#cmakedefine01 CONFIG_AMIX_FILTER
#cmakedefine01 CONFIG_AMULTIPLY_FILTER
#cmakedefine01 CONFIG_ANEQUALIZER_FILTER
#cmakedefine01 CONFIG_ANLMDN_FILTER
#cmakedefine01 CONFIG_ANLMF_FILTER
#cmakedefine01 CONFIG_ANLMS_FILTER
#cmakedefine01 CONFIG_ANULL_FILTER
#cmakedefine01 CONFIG_APAD_FILTER
#cmakedefine01 CONFIG_APERMS_FILTER
#cmakedefine01 CONFIG_APHASER_FILTER
#cmakedefine01 CONFIG_APHASESHIFT_FILTER
#cmakedefine01 CONFIG_APSNR_FILTER
#cmakedefine01 CONFIG_APSYCLIP_FILTER
#cmakedefine01 CONFIG_APULSATOR_FILTER
#cmakedefine01 CONFIG_AREALTIME_FILTER
#cmakedefine01 CONFIG_ARESAMPLE_FILTER
#cmakedefine01 CONFIG_AREVERSE_FILTER
#cmakedefine01 CONFIG_ARLS_FILTER
#cmakedefine01 CONFIG_ARNNDN_FILTER
#cmakedefine01 CONFIG_ASDR_FILTER
#cmakedefine01 CONFIG_ASEGMENT_FILTER
#cmakedefine01 CONFIG_ASELECT_FILTER
#cmakedefine01 CONFIG_ASENDCMD_FILTER
#cmakedefine01 CONFIG_ASETNSAMPLES_FILTER
#cmakedefine01 CONFIG_ASETPTS_FILTER
#cmakedefine01 CONFIG_ASETRATE_FILTER
#cmakedefine01 CONFIG_ASETTB_FILTER
#cmakedefine01 CONFIG_ASHOWINFO_FILTER
#cmakedefine01 CONFIG_ASIDEDATA_FILTER
#cmakedefine01 CONFIG_ASISDR_FILTER
#cmakedefine01 CONFIG_ASOFTCLIP_FILTER
#cmakedefine01 CONFIG_ASPECTRALSTATS_FILTER
#cmakedefine01 CONFIG_ASPLIT_FILTER
#cmakedefine01 CONFIG_ASR_FILTER
#cmakedefine01 CONFIG_ASTATS_FILTER
#cmakedefine01 CONFIG_ASTREAMSELECT_FILTER
#cmakedefine01 CONFIG_ASUBBOOST_FILTER
#cmakedefine01 CONFIG_ASUBCUT_FILTER
#cmakedefine01 CONFIG_ASUPERCUT_FILTER
#cmakedefine01 CONFIG_ASUPERPASS_FILTER
#cmakedefine01 CONFIG_ASUPERSTOP_FILTER
#cmakedefine01 CONFIG_ATEMPO_FILTER
#cmakedefine01 CONFIG_ATILT_FILTER
#cmakedefine01 CONFIG_ATRIM_FILTER
#cmakedefine01 CONFIG_AXCORRELATE_FILTER
#cmakedefine01 CONFIG_AZMQ_FILTER
#cmakedefine01 CONFIG_BANDPASS_FILTER
#cmakedefine01 CONFIG_BANDREJECT_FILTER
#cmakedefine01 CONFIG_BASS_FILTER
#cmakedefine01 CONFIG_BIQUAD_FILTER
#cmakedefine01 CONFIG_BS2B_FILTER
#cmakedefine01 CONFIG_CHANNELMAP_FILTER
#cmakedefine01 CONFIG_CHANNELSPLIT_FILTER
#cmakedefine01 CONFIG_CHORUS_FILTER
#cmakedefine01 CONFIG_COMPAND_FILTER
#cmakedefine01 CONFIG_COMPENSATIONDELAY_FILTER
#cmakedefine01 CONFIG_CROSSFEED_FILTER
#cmakedefine01 CONFIG_CRYSTALIZER_FILTER
#cmakedefine01 CONFIG_DCSHIFT_FILTER
#cmakedefine01 CONFIG_DEESSER_FILTER
#cmakedefine01 CONFIG_DIALOGUENHANCE_FILTER
#cmakedefine01 CONFIG_DRMETER_FILTER
#cmakedefine01 CONFIG_DYNAUDNORM_FILTER
#cmakedefine01 CONFIG_EARWAX_FILTER
#cmakedefine01 CONFIG_EBUR128_FILTER
#cmakedefine01 CONFIG_EQUALIZER_FILTER
#cmakedefine01 CONFIG_EXTRASTEREO_FILTER
#cmakedefine01 CONFIG_FIREQUALIZER_FILTER
#cmakedefine01 CONFIG_FLANGER_FILTER
#cmakedefine01 CONFIG_HAAS_FILTER
#cmakedefine01 CONFIG_HDCD_FILTER
#cmakedefine01 CONFIG_HEADPHONE_FILTER
#cmakedefine01 CONFIG_HIGHPASS_FILTER
#cmakedefine01 CONFIG_HIGHSHELF_FILTER
#cmakedefine01 CONFIG_JOIN_FILTER
#cmakedefine01 CONFIG_LADSPA_FILTER
#cmakedefine01 CONFIG_LOUDNORM_FILTER
#cmakedefine01 CONFIG_LOWPASS_FILTER
#cmakedefine01 CONFIG_LOWSHELF_FILTER
#cmakedefine01 CONFIG_LV2_FILTER
#cmakedefine01 CONFIG_MCOMPAND_FILTER
#cmakedefine01 CONFIG_PAN_FILTER
#cmakedefine01 CONFIG_REPLAYGAIN_FILTER
#cmakedefine01 CONFIG_RUBBERBAND_FILTER
#cmakedefine01 CONFIG_SIDECHAINCOMPRESS_FILTER
#cmakedefine01 CONFIG_SIDECHAINGATE_FILTER
#cmakedefine01 CONFIG_SILENCEDETECT_FILTER
#cmakedefine01 CONFIG_SILENCEREMOVE_FILTER
#cmakedefine01 CONFIG_SOFALIZER_FILTER
#cmakedefine01 CONFIG_SPEECHNORM_FILTER
#cmakedefine01 CONFIG_STEREOTOOLS_FILTER
#cmakedefine01 CONFIG_STEREOWIDEN_FILTER
#cmakedefine01 CONFIG_SUPEREQUALIZER_FILTER
#cmakedefine01 CONFIG_SURROUND_FILTER
#cmakedefine01 CONFIG_TILTSHELF_FILTER
#cmakedefine01 CONFIG_TREBLE_FILTER
#cmakedefine01 CONFIG_TREMOLO_FILTER
#cmakedefine01 CONFIG_VIBRATO_FILTER
#cmakedefine01 CONFIG_VIRTUALBASS_FILTER
#cmakedefine01 CONFIG_VOLUME_FILTER
#cmakedefine01 CONFIG_VOLUMEDETECT_FILTER
#cmakedefine01 CONFIG_AEVALSRC_FILTER
#cmakedefine01 CONFIG_AFDELAYSRC_FILTER
#cmakedefine01 CONFIG_AFIREQSRC_FILTER
#cmakedefine01 CONFIG_AFIRSRC_FILTER
#cmakedefine01 CONFIG_ANOISESRC_FILTER
#cmakedefine01 CONFIG_ANULLSRC_FILTER
#cmakedefine01 CONFIG_FLITE_FILTER
#cmakedefine01 CONFIG_HILBERT_FILTER
#cmakedefine01 CONFIG_SINC_FILTER
#cmakedefine01 CONFIG_SINE_FILTER
#cmakedefine01 CONFIG_ANULLSINK_FILTER
#cmakedefine01 CONFIG_ADDROI_FILTER
#cmakedefine01 CONFIG_ALPHAEXTRACT_FILTER
#cmakedefine01 CONFIG_ALPHAMERGE_FILTER
#cmakedefine01 CONFIG_AMPLIFY_FILTER
#cmakedefine01 CONFIG_ASS_FILTER
#cmakedefine01 CONFIG_ATADENOISE_FILTER
#cmakedefine01 CONFIG_AVGBLUR_FILTER
#cmakedefine01 CONFIG_AVGBLUR_OPENCL_FILTER
#cmakedefine01 CONFIG_AVGBLUR_VULKAN_FILTER
#cmakedefine01 CONFIG_BACKGROUNDKEY_FILTER
#cmakedefine01 CONFIG_BBOX_FILTER
#cmakedefine01 CONFIG_BENCH_FILTER
#cmakedefine01 CONFIG_BILATERAL_FILTER
#cmakedefine01 CONFIG_BILATERAL_CUDA_FILTER
#cmakedefine01 CONFIG_BITPLANENOISE_FILTER
#cmakedefine01 CONFIG_BLACKDETECT_FILTER
#cmakedefine01 CONFIG_BLACKFRAME_FILTER
#cmakedefine01 CONFIG_BLEND_FILTER
#cmakedefine01 CONFIG_BLEND_VULKAN_FILTER
#cmakedefine01 CONFIG_BLOCKDETECT_FILTER
#cmakedefine01 CONFIG_BLURDETECT_FILTER
#cmakedefine01 CONFIG_BM3D_FILTER
#cmakedefine01 CONFIG_BOXBLUR_FILTER
#cmakedefine01 CONFIG_BOXBLUR_OPENCL_FILTER
#cmakedefine01 CONFIG_BWDIF_FILTER
#cmakedefine01 CONFIG_BWDIF_CUDA_FILTER
#cmakedefine01 CONFIG_BWDIF_VULKAN_FILTER
#cmakedefine01 CONFIG_CAS_FILTER
#cmakedefine01 CONFIG_CCREPACK_FILTER
#cmakedefine01 CONFIG_CHROMABER_VULKAN_FILTER
#cmakedefine01 CONFIG_CHROMAHOLD_FILTER
#cmakedefine01 CONFIG_CHROMAKEY_FILTER
#cmakedefine01 CONFIG_CHROMAKEY_CUDA_FILTER
#cmakedefine01 CONFIG_CHROMANR_FILTER
#cmakedefine01 CONFIG_CHROMASHIFT_FILTER
#cmakedefine01 CONFIG_CIESCOPE_FILTER
#cmakedefine01 CONFIG_CODECVIEW_FILTER
#cmakedefine01 CONFIG_COLORBALANCE_FILTER
#cmakedefine01 CONFIG_COLORCHANNELMIXER_FILTER
#cmakedefine01 CONFIG_COLORCONTRAST_FILTER
#cmakedefine01 CONFIG_COLORCORRECT_FILTER
#cmakedefine01 CONFIG_COLORIZE_FILTER
#cmakedefine01 CONFIG_COLORKEY_FILTER
#cmakedefine01 CONFIG_COLORKEY_OPENCL_FILTER
#cmakedefine01 CONFIG_COLORHOLD_FILTER
#cmakedefine01 CONFIG_COLORLEVELS_FILTER
#cmakedefine01 CONFIG_COLORMAP_FILTER
#cmakedefine01 CONFIG_COLORMATRIX_FILTER
#cmakedefine01 CONFIG_COLORSPACE_FILTER
#cmakedefine01 CONFIG_COLORSPACE_CUDA_FILTER
#cmakedefine01 CONFIG_COLORTEMPERATURE_FILTER
#cmakedefine01 CONFIG_CONVOLUTION_FILTER
#cmakedefine01 CONFIG_CONVOLUTION_OPENCL_FILTER
#cmakedefine01 CONFIG_CONVOLVE_FILTER
#cmakedefine01 CONFIG_COPY_FILTER
#cmakedefine01 CONFIG_COREIMAGE_FILTER
#cmakedefine01 CONFIG_CORR_FILTER
#cmakedefine01 CONFIG_COVER_RECT_FILTER
#cmakedefine01 CONFIG_CROP_FILTER
#cmakedefine01 CONFIG_CROPDETECT_FILTER
#cmakedefine01 CONFIG_CUE_FILTER
#cmakedefine01 CONFIG_CURVES_FILTER
#cmakedefine01 CONFIG_DATASCOPE_FILTER
#cmakedefine01 CONFIG_DBLUR_FILTER
#cmakedefine01 CONFIG_DCTDNOIZ_FILTER
#cmakedefine01 CONFIG_DEBAND_FILTER
#cmakedefine01 CONFIG_DEBLOCK_FILTER
#cmakedefine01 CONFIG_DECIMATE_FILTER
#cmakedefine01 CONFIG_DECONVOLVE_FILTER
#cmakedefine01 CONFIG_DEDOT_FILTER
#cmakedefine01 CONFIG_DEFLATE_FILTER
#cmakedefine01 CONFIG_DEFLICKER_FILTER
#cmakedefine01 CONFIG_DEINTERLACE_QSV_FILTER
#cmakedefine01 CONFIG_DEINTERLACE_VAAPI_FILTER
#cmakedefine01 CONFIG_DEJUDDER_FILTER
#cmakedefine01 CONFIG_DELOGO_FILTER
#cmakedefine01 CONFIG_DENOISE_VAAPI_FILTER
#cmakedefine01 CONFIG_DERAIN_FILTER
#cmakedefine01 CONFIG_DESHAKE_FILTER
#cmakedefine01 CONFIG_DESHAKE_OPENCL_FILTER
#cmakedefine01 CONFIG_DESPILL_FILTER
#cmakedefine01 CONFIG_DETELECINE_FILTER
#cmakedefine01 CONFIG_DILATION_FILTER
#cmakedefine01 CONFIG_DILATION_OPENCL_FILTER
#cmakedefine01 CONFIG_DISPLACE_FILTER
#cmakedefine01 CONFIG_DNN_CLASSIFY_FILTER
#cmakedefine01 CONFIG_DNN_DETECT_FILTER
#cmakedefine01 CONFIG_DNN_PROCESSING_FILTER
#cmakedefine01 CONFIG_DOUBLEWEAVE_FILTER
#cmakedefine01 CONFIG_DRAWBOX_FILTER
#cmakedefine01 CONFIG_DRAWGRAPH_FILTER
#cmakedefine01 CONFIG_DRAWGRID_FILTER
#cmakedefine01 CONFIG_DRAWTEXT_FILTER
#cmakedefine01 CONFIG_EDGEDETECT_FILTER
#cmakedefine01 CONFIG_ELBG_FILTER
#cmakedefine01 CONFIG_ENTROPY_FILTER
#cmakedefine01 CONFIG_EPX_FILTER
#cmakedefine01 CONFIG_EQ_FILTER
#cmakedefine01 CONFIG_EROSION_FILTER
#cmakedefine01 CONFIG_EROSION_OPENCL_FILTER
#cmakedefine01 CONFIG_ESTDIF_FILTER
#cmakedefine01 CONFIG_EXPOSURE_FILTER
#cmakedefine01 CONFIG_EXTRACTPLANES_FILTER
#cmakedefine01 CONFIG_FADE_FILTER
#cmakedefine01 CONFIG_FEEDBACK_FILTER
#cmakedefine01 CONFIG_FFTDNOIZ_FILTER
#cmakedefine01 CONFIG_FFTFILT_FILTER
#cmakedefine01 CONFIG_FIELD_FILTER
#cmakedefine01 CONFIG_FIELDHINT_FILTER
#cmakedefine01 CONFIG_FIELDMATCH_FILTER
#cmakedefine01 CONFIG_FIELDORDER_FILTER
#cmakedefine01 CONFIG_FILLBORDERS_FILTER
#cmakedefine01 CONFIG_FIND_RECT_FILTER
#cmakedefine01 CONFIG_FLIP_VULKAN_FILTER
#cmakedefine01 CONFIG_FLOODFILL_FILTER
#cmakedefine01 CONFIG_FORMAT_FILTER
#cmakedefine01 CONFIG_FPS_FILTER
#cmakedefine01 CONFIG_FRAMEPACK_FILTER
#cmakedefine01 CONFIG_FRAMERATE_FILTER
#cmakedefine01 CONFIG_FRAMESTEP_FILTER
#cmakedefine01 CONFIG_FREEZEDETECT_FILTER
#cmakedefine01 CONFIG_FREEZEFRAMES_FILTER
#cmakedefine01 CONFIG_FREI0R_FILTER
#cmakedefine01 CONFIG_FSPP_FILTER
#cmakedefine01 CONFIG_FSYNC_FILTER
#cmakedefine01 CONFIG_GBLUR_FILTER
#cmakedefine01 CONFIG_GBLUR_VULKAN_FILTER
#cmakedefine01 CONFIG_GEQ_FILTER
#cmakedefine01 CONFIG_GRADFUN_FILTER
#cmakedefine01 CONFIG_GRAPHMONITOR_FILTER
#cmakedefine01 CONFIG_GRAYWORLD_FILTER
#cmakedefine01 CONFIG_GREYEDGE_FILTER
#cmakedefine01 CONFIG_GUIDED_FILTER
#cmakedefine01 CONFIG_HALDCLUT_FILTER
#cmakedefine01 CONFIG_HFLIP_FILTER
#cmakedefine01 CONFIG_HFLIP_VULKAN_FILTER
#cmakedefine01 CONFIG_HISTEQ_FILTER
#cmakedefine01 CONFIG_HISTOGRAM_FILTER
#cmakedefine01 CONFIG_HQDN3D_FILTER
#cmakedefine01 CONFIG_HQX_FILTER
#cmakedefine01 CONFIG_HSTACK_FILTER
#cmakedefine01 CONFIG_HSVHOLD_FILTER
#cmakedefine01 CONFIG_HSVKEY_FILTER
#cmakedefine01 CONFIG_HUE_FILTER
#cmakedefine01 CONFIG_HUESATURATION_FILTER
#cmakedefine01 CONFIG_HWDOWNLOAD_FILTER
#cmakedefine01 CONFIG_HWMAP_FILTER
#cmakedefine01 CONFIG_HWUPLOAD_FILTER
#cmakedefine01 CONFIG_HWUPLOAD_CUDA_FILTER
#cmakedefine01 CONFIG_HYSTERESIS_FILTER
#cmakedefine01 CONFIG_ICCDETECT_FILTER
#cmakedefine01 CONFIG_ICCGEN_FILTER
#cmakedefine01 CONFIG_IDENTITY_FILTER
#cmakedefine01 CONFIG_IDET_FILTER
#cmakedefine01 CONFIG_IL_FILTER
#cmakedefine01 CONFIG_INFLATE_FILTER
#cmakedefine01 CONFIG_INTERLACE_FILTER
#cmakedefine01 CONFIG_INTERLEAVE_FILTER
#cmakedefine01 CONFIG_KERNDEINT_FILTER
#cmakedefine01 CONFIG_KIRSCH_FILTER
#cmakedefine01 CONFIG_LAGFUN_FILTER
#cmakedefine01 CONFIG_LATENCY_FILTER
#cmakedefine01 CONFIG_LENSCORRECTION_FILTER
#cmakedefine01 CONFIG_LENSFUN_FILTER
#cmakedefine01 CONFIG_LIBPLACEBO_FILTER
#cmakedefine01 CONFIG_LIBVMAF_FILTER
#cmakedefine01 CONFIG_LIBVMAF_CUDA_FILTER
#cmakedefine01 CONFIG_LIMITDIFF_FILTER
#cmakedefine01 CONFIG_LIMITER_FILTER
#cmakedefine01 CONFIG_LOOP_FILTER
#cmakedefine01 CONFIG_LUMAKEY_FILTER
#cmakedefine01 CONFIG_LUT_FILTER
#cmakedefine01 CONFIG_LUT1D_FILTER
#cmakedefine01 CONFIG_LUT2_FILTER
#cmakedefine01 CONFIG_LUT3D_FILTER
#cmakedefine01 CONFIG_LUTRGB_FILTER
#cmakedefine01 CONFIG_LUTYUV_FILTER
#cmakedefine01 CONFIG_MASKEDCLAMP_FILTER
#cmakedefine01 CONFIG_MASKEDMAX_FILTER
#cmakedefine01 CONFIG_MASKEDMERGE_FILTER
#cmakedefine01 CONFIG_MASKEDMIN_FILTER
#cmakedefine01 CONFIG_MASKEDTHRESHOLD_FILTER
#cmakedefine01 CONFIG_MASKFUN_FILTER
#cmakedefine01 CONFIG_MCDEINT_FILTER
#cmakedefine01 CONFIG_MEDIAN_FILTER
#cmakedefine01 CONFIG_MERGEPLANES_FILTER
#cmakedefine01 CONFIG_MESTIMATE_FILTER
#cmakedefine01 CONFIG_METADATA_FILTER
#cmakedefine01 CONFIG_MIDEQUALIZER_FILTER
#cmakedefine01 CONFIG_MINTERPOLATE_FILTER
#cmakedefine01 CONFIG_MIX_FILTER
#cmakedefine01 CONFIG_MONOCHROME_FILTER
#cmakedefine01 CONFIG_MORPHO_FILTER
#cmakedefine01 CONFIG_MPDECIMATE_FILTER
#cmakedefine01 CONFIG_MSAD_FILTER
#cmakedefine01 CONFIG_MULTIPLY_FILTER
#cmakedefine01 CONFIG_NEGATE_FILTER
#cmakedefine01 CONFIG_NLMEANS_FILTER
#cmakedefine01 CONFIG_NLMEANS_OPENCL_FILTER
#cmakedefine01 CONFIG_NLMEANS_VULKAN_FILTER
#cmakedefine01 CONFIG_NNEDI_FILTER
#cmakedefine01 CONFIG_NOFORMAT_FILTER
#cmakedefine01 CONFIG_NOISE_FILTER
#cmakedefine01 CONFIG_NORMALIZE_FILTER
#cmakedefine01 CONFIG_NULL_FILTER
#cmakedefine01 CONFIG_OCR_FILTER
#cmakedefine01 CONFIG_OCV_FILTER
#cmakedefine01 CONFIG_OSCILLOSCOPE_FILTER
#cmakedefine01 CONFIG_OVERLAY_FILTER
#cmakedefine01 CONFIG_OVERLAY_OPENCL_FILTER
#cmakedefine01 CONFIG_OVERLAY_QSV_FILTER
#cmakedefine01 CONFIG_OVERLAY_VAAPI_FILTER
#cmakedefine01 CONFIG_OVERLAY_VULKAN_FILTER
#cmakedefine01 CONFIG_OVERLAY_CUDA_FILTER
#cmakedefine01 CONFIG_OWDENOISE_FILTER
#cmakedefine01 CONFIG_PAD_FILTER
#cmakedefine01 CONFIG_PAD_OPENCL_FILTER
#cmakedefine01 CONFIG_PALETTEGEN_FILTER
#cmakedefine01 CONFIG_PALETTEUSE_FILTER
#cmakedefine01 CONFIG_PERMS_FILTER
#cmakedefine01 CONFIG_PERSPECTIVE_FILTER
#cmakedefine01 CONFIG_PHASE_FILTER
#cmakedefine01 CONFIG_PHOTOSENSITIVITY_FILTER
#cmakedefine01 CONFIG_PIXDESCTEST_FILTER
#cmakedefine01 CONFIG_PIXELIZE_FILTER
#cmakedefine01 CONFIG_PIXSCOPE_FILTER
#cmakedefine01 CONFIG_PP_FILTER
#cmakedefine01 CONFIG_PP7_FILTER
#cmakedefine01 CONFIG_PREMULTIPLY_FILTER
#cmakedefine01 CONFIG_PREWITT_FILTER
#cmakedefine01 CONFIG_PREWITT_OPENCL_FILTER
#cmakedefine01 CONFIG_PROCAMP_VAAPI_FILTER
#cmakedefine01 CONFIG_PROGRAM_OPENCL_FILTER
#cmakedefine01 CONFIG_PSEUDOCOLOR_FILTER
#cmakedefine01 CONFIG_PSNR_FILTER
#cmakedefine01 CONFIG_PULLUP_FILTER
#cmakedefine01 CONFIG_QP_FILTER
#cmakedefine01 CONFIG_QRENCODE_FILTER
#cmakedefine01 CONFIG_QUIRC_FILTER
#cmakedefine01 CONFIG_RANDOM_FILTER
#cmakedefine01 CONFIG_READEIA608_FILTER
#cmakedefine01 CONFIG_READVITC_FILTER
#cmakedefine01 CONFIG_REALTIME_FILTER
#cmakedefine01 CONFIG_REMAP_FILTER
#cmakedefine01 CONFIG_REMAP_OPENCL_FILTER
#cmakedefine01 CONFIG_REMOVEGRAIN_FILTER
#cmakedefine01 CONFIG_REMOVELOGO_FILTER
#cmakedefine01 CONFIG_REPEATFIELDS_FILTER
#cmakedefine01 CONFIG_REVERSE_FILTER
#cmakedefine01 CONFIG_RGBASHIFT_FILTER
#cmakedefine01 CONFIG_ROBERTS_FILTER
#cmakedefine01 CONFIG_ROBERTS_OPENCL_FILTER
#cmakedefine01 CONFIG_ROTATE_FILTER
#cmakedefine01 CONFIG_SAB_FILTER
#cmakedefine01 CONFIG_SCALE_FILTER
#cmakedefine01 CONFIG_SCALE_CUDA_FILTER
#cmakedefine01 CONFIG_SCALE_NPP_FILTER
#cmakedefine01 CONFIG_SCALE_QSV_FILTER
#cmakedefine01 CONFIG_SCALE_VAAPI_FILTER
#cmakedefine01 CONFIG_SCALE_VT_FILTER
#cmakedefine01 CONFIG_SCALE_VULKAN_FILTER
#cmakedefine01 CONFIG_SCALE2REF_FILTER
#cmakedefine01 CONFIG_SCALE2REF_NPP_FILTER
#cmakedefine01 CONFIG_SCDET_FILTER
#cmakedefine01 CONFIG_SCHARR_FILTER
#cmakedefine01 CONFIG_SCROLL_FILTER
#cmakedefine01 CONFIG_SEGMENT_FILTER
#cmakedefine01 CONFIG_SELECT_FILTER
#cmakedefine01 CONFIG_SELECTIVECOLOR_FILTER
#cmakedefine01 CONFIG_SENDCMD_FILTER
#cmakedefine01 CONFIG_SEPARATEFIELDS_FILTER
#cmakedefine01 CONFIG_SETDAR_FILTER
#cmakedefine01 CONFIG_SETFIELD_FILTER
#cmakedefine01 CONFIG_SETPARAMS_FILTER
#cmakedefine01 CONFIG_SETPTS_FILTER
#cmakedefine01 CONFIG_SETRANGE_FILTER
#cmakedefine01 CONFIG_SETSAR_FILTER
#cmakedefine01 CONFIG_SETTB_FILTER
#cmakedefine01 CONFIG_SHARPEN_NPP_FILTER
#cmakedefine01 CONFIG_SHARPNESS_VAAPI_FILTER
#cmakedefine01 CONFIG_SHEAR_FILTER
#cmakedefine01 CONFIG_SHOWINFO_FILTER
#cmakedefine01 CONFIG_SHOWPALETTE_FILTER
#cmakedefine01 CONFIG_SHUFFLEFRAMES_FILTER
#cmakedefine01 CONFIG_SHUFFLEPIXELS_FILTER
#cmakedefine01 CONFIG_SHUFFLEPLANES_FILTER
#cmakedefine01 CONFIG_SIDEDATA_FILTER
#cmakedefine01 CONFIG_SIGNALSTATS_FILTER
#cmakedefine01 CONFIG_SIGNATURE_FILTER
#cmakedefine01 CONFIG_SITI_FILTER
#cmakedefine01 CONFIG_SMARTBLUR_FILTER
#cmakedefine01 CONFIG_SOBEL_FILTER
#cmakedefine01 CONFIG_SOBEL_OPENCL_FILTER
#cmakedefine01 CONFIG_SPLIT_FILTER
#cmakedefine01 CONFIG_SPP_FILTER
#cmakedefine01 CONFIG_SR_FILTER
#cmakedefine01 CONFIG_SSIM_FILTER
#cmakedefine01 CONFIG_SSIM360_FILTER
#cmakedefine01 CONFIG_STEREO3D_FILTER
#cmakedefine01 CONFIG_STREAMSELECT_FILTER
#cmakedefine01 CONFIG_SUBTITLES_FILTER
#cmakedefine01 CONFIG_SUPER2XSAI_FILTER
#cmakedefine01 CONFIG_SWAPRECT_FILTER
#cmakedefine01 CONFIG_SWAPUV_FILTER
#cmakedefine01 CONFIG_TBLEND_FILTER
#cmakedefine01 CONFIG_TELECINE_FILTER
#cmakedefine01 CONFIG_THISTOGRAM_FILTER
#cmakedefine01 CONFIG_THRESHOLD_FILTER
#cmakedefine01 CONFIG_THUMBNAIL_FILTER
#cmakedefine01 CONFIG_THUMBNAIL_CUDA_FILTER
#cmakedefine01 CONFIG_TILE_FILTER
#cmakedefine01 CONFIG_TILTANDSHIFT_FILTER
#cmakedefine01 CONFIG_TINTERLACE_FILTER
#cmakedefine01 CONFIG_TLUT2_FILTER
#cmakedefine01 CONFIG_TMEDIAN_FILTER
#cmakedefine01 CONFIG_TMIDEQUALIZER_FILTER
#cmakedefine01 CONFIG_TMIX_FILTER
#cmakedefine01 CONFIG_TONEMAP_FILTER
#cmakedefine01 CONFIG_TONEMAP_OPENCL_FILTER
#cmakedefine01 CONFIG_TONEMAP_VAAPI_FILTER
#cmakedefine01 CONFIG_TPAD_FILTER
#cmakedefine01 CONFIG_TRANSPOSE_FILTER
#cmakedefine01 CONFIG_TRANSPOSE_NPP_FILTER
#cmakedefine01 CONFIG_TRANSPOSE_OPENCL_FILTER
#cmakedefine01 CONFIG_TRANSPOSE_VAAPI_FILTER
#cmakedefine01 CONFIG_TRANSPOSE_VT_FILTER
#cmakedefine01 CONFIG_TRANSPOSE_VULKAN_FILTER
#cmakedefine01 CONFIG_TRIM_FILTER
#cmakedefine01 CONFIG_UNPREMULTIPLY_FILTER
#cmakedefine01 CONFIG_UNSHARP_FILTER
#cmakedefine01 CONFIG_UNSHARP_OPENCL_FILTER
#cmakedefine01 CONFIG_UNTILE_FILTER
#cmakedefine01 CONFIG_USPP_FILTER
#cmakedefine01 CONFIG_V360_FILTER
#cmakedefine01 CONFIG_VAGUEDENOISER_FILTER
#cmakedefine01 CONFIG_VARBLUR_FILTER
#cmakedefine01 CONFIG_VECTORSCOPE_FILTER
#cmakedefine01 CONFIG_VFLIP_FILTER
#cmakedefine01 CONFIG_VFLIP_VULKAN_FILTER
#cmakedefine01 CONFIG_VFRDET_FILTER
#cmakedefine01 CONFIG_VIBRANCE_FILTER
#cmakedefine01 CONFIG_VIDSTABDETECT_FILTER
#cmakedefine01 CONFIG_VIDSTABTRANSFORM_FILTER
#cmakedefine01 CONFIG_VIF_FILTER
#cmakedefine01 CONFIG_VIGNETTE_FILTER
#cmakedefine01 CONFIG_VMAFMOTION_FILTER
#cmakedefine01 CONFIG_VPP_QSV_FILTER
#cmakedefine01 CONFIG_VSTACK_FILTER
#cmakedefine01 CONFIG_W3FDIF_FILTER
#cmakedefine01 CONFIG_WAVEFORM_FILTER
#cmakedefine01 CONFIG_WEAVE_FILTER
#cmakedefine01 CONFIG_XBR_FILTER
#cmakedefine01 CONFIG_XCORRELATE_FILTER
#cmakedefine01 CONFIG_XFADE_FILTER
#cmakedefine01 CONFIG_XFADE_OPENCL_FILTER
#cmakedefine01 CONFIG_XFADE_VULKAN_FILTER
#cmakedefine01 CONFIG_XMEDIAN_FILTER
#cmakedefine01 CONFIG_XSTACK_FILTER
#cmakedefine01 CONFIG_YADIF_FILTER
#cmakedefine01 CONFIG_YADIF_CUDA_FILTER
#cmakedefine01 CONFIG_YADIF_VIDEOTOOLBOX_FILTER
#cmakedefine01 CONFIG_YAEPBLUR_FILTER
#cmakedefine01 CONFIG_ZMQ_FILTER
#cmakedefine01 CONFIG_ZOOMPAN_FILTER
#cmakedefine01 CONFIG_ZSCALE_FILTER
#cmakedefine01 CONFIG_HSTACK_VAAPI_FILTER
#cmakedefine01 CONFIG_VSTACK_VAAPI_FILTER
#cmakedefine01 CONFIG_XSTACK_VAAPI_FILTER
#cmakedefine01 CONFIG_HSTACK_QSV_FILTER
#cmakedefine01 CONFIG_VSTACK_QSV_FILTER
#cmakedefine01 CONFIG_XSTACK_QSV_FILTER
#cmakedefine01 CONFIG_ALLRGB_FILTER
#cmakedefine01 CONFIG_ALLYUV_FILTER
#cmakedefine01 CONFIG_CELLAUTO_FILTER
#cmakedefine01 CONFIG_COLOR_FILTER
#cmakedefine01 CONFIG_COLOR_VULKAN_FILTER
#cmakedefine01 CONFIG_COLORCHART_FILTER
#cmakedefine01 CONFIG_COLORSPECTRUM_FILTER
#cmakedefine01 CONFIG_COREIMAGESRC_FILTER
#cmakedefine01 CONFIG_DDAGRAB_FILTER
#cmakedefine01 CONFIG_FREI0R_SRC_FILTER
#cmakedefine01 CONFIG_GRADIENTS_FILTER
#cmakedefine01 CONFIG_HALDCLUTSRC_FILTER
#cmakedefine01 CONFIG_LIFE_FILTER
#cmakedefine01 CONFIG_MANDELBROT_FILTER
#cmakedefine01 CONFIG_MPTESTSRC_FILTER
#cmakedefine01 CONFIG_NULLSRC_FILTER
#cmakedefine01 CONFIG_OPENCLSRC_FILTER
#cmakedefine01 CONFIG_QRENCODESRC_FILTER
#cmakedefine01 CONFIG_PAL75BARS_FILTER
#cmakedefine01 CONFIG_PAL100BARS_FILTER
#cmakedefine01 CONFIG_RGBTESTSRC_FILTER
#cmakedefine01 CONFIG_SIERPINSKI_FILTER
#cmakedefine01 CONFIG_SMPTEBARS_FILTER
#cmakedefine01 CONFIG_SMPTEHDBARS_FILTER
#cmakedefine01 CONFIG_TESTSRC_FILTER
#cmakedefine01 CONFIG_TESTSRC2_FILTER
#cmakedefine01 CONFIG_YUVTESTSRC_FILTER
#cmakedefine01 CONFIG_ZONEPLATE_FILTER
#cmakedefine01 CONFIG_NULLSINK_FILTER
#cmakedefine01 CONFIG_A3DSCOPE_FILTER
#cmakedefine01 CONFIG_ABITSCOPE_FILTER
#cmakedefine01 CONFIG_ADRAWGRAPH_FILTER
#cmakedefine01 CONFIG_AGRAPHMONITOR_FILTER
#cmakedefine01 CONFIG_AHISTOGRAM_FILTER
#cmakedefine01 CONFIG_APHASEMETER_FILTER
#cmakedefine01 CONFIG_AVECTORSCOPE_FILTER
#cmakedefine01 CONFIG_CONCAT_FILTER
#cmakedefine01 CONFIG_SHOWCQT_FILTER
#cmakedefine01 CONFIG_SHOWCWT_FILTER
#cmakedefine01 CONFIG_SHOWFREQS_FILTER
#cmakedefine01 CONFIG_SHOWSPATIAL_FILTER
#cmakedefine01 CONFIG_SHOWSPECTRUM_FILTER
#cmakedefine01 CONFIG_SHOWSPECTRUMPIC_FILTER
#cmakedefine01 CONFIG_SHOWVOLUME_FILTER
#cmakedefine01 CONFIG_SHOWWAVES_FILTER
#cmakedefine01 CONFIG_SHOWWAVESPIC_FILTER
#cmakedefine01 CONFIG_SPECTRUMSYNTH_FILTER
#cmakedefine01 CONFIG_AVSYNCTEST_FILTER
#cmakedefine01 CONFIG_AMOVIE_FILTER
#cmakedefine01 CONFIG_MOVIE_FILTER
#cmakedefine01 CONFIG_AA_DEMUXER
#cmakedefine01 CONFIG_AAC_DEMUXER
#cmakedefine01 CONFIG_AAX_DEMUXER
#cmakedefine01 CONFIG_AC3_DEMUXER
#cmakedefine01 CONFIG_AC4_DEMUXER
#cmakedefine01 CONFIG_ACE_DEMUXER
#cmakedefine01 CONFIG_ACM_DEMUXER
#cmakedefine01 CONFIG_ACT_DEMUXER
#cmakedefine01 CONFIG_ADF_DEMUXER
#cmakedefine01 CONFIG_ADP_DEMUXER
#cmakedefine01 CONFIG_ADS_DEMUXER
#cmakedefine01 CONFIG_ADX_DEMUXER
#cmakedefine01 CONFIG_AEA_DEMUXER
#cmakedefine01 CONFIG_AFC_DEMUXER
#cmakedefine01 CONFIG_AIFF_DEMUXER
#cmakedefine01 CONFIG_AIX_DEMUXER
#cmakedefine01 CONFIG_ALP_DEMUXER
#cmakedefine01 CONFIG_AMR_DEMUXER
#cmakedefine01 CONFIG_AMRNB_DEMUXER
#cmakedefine01 CONFIG_AMRWB_DEMUXER
#cmakedefine01 CONFIG_ANM_DEMUXER
#cmakedefine01 CONFIG_APAC_DEMUXER
#cmakedefine01 CONFIG_APC_DEMUXER
#cmakedefine01 CONFIG_APE_DEMUXER
#cmakedefine01 CONFIG_APM_DEMUXER
#cmakedefine01 CONFIG_APNG_DEMUXER
#cmakedefine01 CONFIG_APTX_DEMUXER
#cmakedefine01 CONFIG_APTX_HD_DEMUXER
#cmakedefine01 CONFIG_AQTITLE_DEMUXER
#cmakedefine01 CONFIG_ARGO_ASF_DEMUXER
#cmakedefine01 CONFIG_ARGO_BRP_DEMUXER
#cmakedefine01 CONFIG_ARGO_CVG_DEMUXER
#cmakedefine01 CONFIG_ASF_DEMUXER
#cmakedefine01 CONFIG_ASF_O_DEMUXER
#cmakedefine01 CONFIG_ASS_DEMUXER
#cmakedefine01 CONFIG_AST_DEMUXER
#cmakedefine01 CONFIG_AU_DEMUXER
#cmakedefine01 CONFIG_AV1_DEMUXER
#cmakedefine01 CONFIG_AVI_DEMUXER
#cmakedefine01 CONFIG_AVISYNTH_DEMUXER
#cmakedefine01 CONFIG_AVR_DEMUXER
#cmakedefine01 CONFIG_AVS_DEMUXER
#cmakedefine01 CONFIG_AVS2_DEMUXER
#cmakedefine01 CONFIG_AVS3_DEMUXER
#cmakedefine01 CONFIG_BETHSOFTVID_DEMUXER
#cmakedefine01 CONFIG_BFI_DEMUXER
#cmakedefine01 CONFIG_BINTEXT_DEMUXER
#cmakedefine01 CONFIG_BINK_DEMUXER
#cmakedefine01 CONFIG_BINKA_DEMUXER
#cmakedefine01 CONFIG_BIT_DEMUXER
#cmakedefine01 CONFIG_BITPACKED_DEMUXER
#cmakedefine01 CONFIG_BMV_DEMUXER
#cmakedefine01 CONFIG_BFSTM_DEMUXER
#cmakedefine01 CONFIG_BRSTM_DEMUXER
#cmakedefine01 CONFIG_BOA_DEMUXER
#cmakedefine01 CONFIG_BONK_DEMUXER
#cmakedefine01 CONFIG_C93_DEMUXER
#cmakedefine01 CONFIG_CAF_DEMUXER
#cmakedefine01 CONFIG_CAVSVIDEO_DEMUXER
#cmakedefine01 CONFIG_CDG_DEMUXER
#cmakedefine01 CONFIG_CDXL_DEMUXER
#cmakedefine01 CONFIG_CINE_DEMUXER
#cmakedefine01 CONFIG_CODEC2_DEMUXER
#cmakedefine01 CONFIG_CODEC2RAW_DEMUXER
#cmakedefine01 CONFIG_CONCAT_DEMUXER
#cmakedefine01 CONFIG_DASH_DEMUXER
#cmakedefine01 CONFIG_DATA_DEMUXER
#cmakedefine01 CONFIG_DAUD_DEMUXER
#cmakedefine01 CONFIG_DCSTR_DEMUXER
#cmakedefine01 CONFIG_DERF_DEMUXER
#cmakedefine01 CONFIG_DFA_DEMUXER
#cmakedefine01 CONFIG_DFPWM_DEMUXER
#cmakedefine01 CONFIG_DHAV_DEMUXER
#cmakedefine01 CONFIG_DIRAC_DEMUXER
#cmakedefine01 CONFIG_DNXHD_DEMUXER
#cmakedefine01 CONFIG_DSF_DEMUXER
#cmakedefine01 CONFIG_DSICIN_DEMUXER
#cmakedefine01 CONFIG_DSS_DEMUXER
#cmakedefine01 CONFIG_DTS_DEMUXER
#cmakedefine01 CONFIG_DTSHD_DEMUXER
#cmakedefine01 CONFIG_DV_DEMUXER
#cmakedefine01 CONFIG_DVBSUB_DEMUXER
#cmakedefine01 CONFIG_DVBTXT_DEMUXER
#cmakedefine01 CONFIG_DVDVIDEO_DEMUXER
#cmakedefine01 CONFIG_DXA_DEMUXER
#cmakedefine01 CONFIG_EA_DEMUXER
#cmakedefine01 CONFIG_EA_CDATA_DEMUXER
#cmakedefine01 CONFIG_EAC3_DEMUXER
#cmakedefine01 CONFIG_EPAF_DEMUXER
#cmakedefine01 CONFIG_EVC_DEMUXER
#cmakedefine01 CONFIG_FFMETADATA_DEMUXER
#cmakedefine01 CONFIG_FILMSTRIP_DEMUXER
#cmakedefine01 CONFIG_FITS_DEMUXER
#cmakedefine01 CONFIG_FLAC_DEMUXER
#cmakedefine01 CONFIG_FLIC_DEMUXER
#cmakedefine01 CONFIG_FLV_DEMUXER
#cmakedefine01 CONFIG_LIVE_FLV_DEMUXER
#cmakedefine01 CONFIG_FOURXM_DEMUXER
#cmakedefine01 CONFIG_FRM_DEMUXER
#cmakedefine01 CONFIG_FSB_DEMUXER
#cmakedefine01 CONFIG_FWSE_DEMUXER
#cmakedefine01 CONFIG_G722_DEMUXER
#cmakedefine01 CONFIG_G723_1_DEMUXER
#cmakedefine01 CONFIG_G726_DEMUXER
#cmakedefine01 CONFIG_G726LE_DEMUXER
#cmakedefine01 CONFIG_G729_DEMUXER
#cmakedefine01 CONFIG_GDV_DEMUXER
#cmakedefine01 CONFIG_GENH_DEMUXER
#cmakedefine01 CONFIG_GIF_DEMUXER
#cmakedefine01 CONFIG_GSM_DEMUXER
#cmakedefine01 CONFIG_GXF_DEMUXER
#cmakedefine01 CONFIG_H261_DEMUXER
#cmakedefine01 CONFIG_H263_DEMUXER
#cmakedefine01 CONFIG_H264_DEMUXER
#cmakedefine01 CONFIG_HCA_DEMUXER
#cmakedefine01 CONFIG_HCOM_DEMUXER
#cmakedefine01 CONFIG_HEVC_DEMUXER
#cmakedefine01 CONFIG_HLS_DEMUXER
#cmakedefine01 CONFIG_HNM_DEMUXER
#cmakedefine01 CONFIG_IAMF_DEMUXER
#cmakedefine01 CONFIG_ICO_DEMUXER
#cmakedefine01 CONFIG_IDCIN_DEMUXER
#cmakedefine01 CONFIG_IDF_DEMUXER
#cmakedefine01 CONFIG_IFF_DEMUXER
#cmakedefine01 CONFIG_IFV_DEMUXER
#cmakedefine01 CONFIG_ILBC_DEMUXER
#cmakedefine01 CONFIG_IMAGE2_DEMUXER
#cmakedefine01 CONFIG_IMAGE2PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE2_ALIAS_PIX_DEMUXER
#cmakedefine01 CONFIG_IMAGE2_BRENDER_PIX_DEMUXER
#cmakedefine01 CONFIG_IMF_DEMUXER
#cmakedefine01 CONFIG_INGENIENT_DEMUXER
#cmakedefine01 CONFIG_IPMOVIE_DEMUXER
#cmakedefine01 CONFIG_IPU_DEMUXER
#cmakedefine01 CONFIG_IRCAM_DEMUXER
#cmakedefine01 CONFIG_ISS_DEMUXER
#cmakedefine01 CONFIG_IV8_DEMUXER
#cmakedefine01 CONFIG_IVF_DEMUXER
#cmakedefine01 CONFIG_IVR_DEMUXER
#cmakedefine01 CONFIG_JACOSUB_DEMUXER
#cmakedefine01 CONFIG_JV_DEMUXER
#cmakedefine01 CONFIG_JPEGXL_ANIM_DEMUXER
#cmakedefine01 CONFIG_KUX_DEMUXER
#cmakedefine01 CONFIG_KVAG_DEMUXER
#cmakedefine01 CONFIG_LAF_DEMUXER
#cmakedefine01 CONFIG_LMLM4_DEMUXER
#cmakedefine01 CONFIG_LOAS_DEMUXER
#cmakedefine01 CONFIG_LUODAT_DEMUXER
#cmakedefine01 CONFIG_LRC_DEMUXER
#cmakedefine01 CONFIG_LVF_DEMUXER
#cmakedefine01 CONFIG_LXF_DEMUXER
#cmakedefine01 CONFIG_M4V_DEMUXER
#cmakedefine01 CONFIG_MCA_DEMUXER
#cmakedefine01 CONFIG_MCC_DEMUXER
#cmakedefine01 CONFIG_MATROSKA_DEMUXER
#cmakedefine01 CONFIG_MGSTS_DEMUXER
#cmakedefine01 CONFIG_MICRODVD_DEMUXER
#cmakedefine01 CONFIG_MJPEG_DEMUXER
#cmakedefine01 CONFIG_MJPEG_2000_DEMUXER
#cmakedefine01 CONFIG_MLP_DEMUXER
#cmakedefine01 CONFIG_MLV_DEMUXER
#cmakedefine01 CONFIG_MM_DEMUXER
#cmakedefine01 CONFIG_MMF_DEMUXER
#cmakedefine01 CONFIG_MODS_DEMUXER
#cmakedefine01 CONFIG_MOFLEX_DEMUXER
#cmakedefine01 CONFIG_MOV_DEMUXER
#cmakedefine01 CONFIG_MP3_DEMUXER
#cmakedefine01 CONFIG_MPC_DEMUXER
#cmakedefine01 CONFIG_MPC8_DEMUXER
#cmakedefine01 CONFIG_MPEGPS_DEMUXER
#cmakedefine01 CONFIG_MPEGTS_DEMUXER
#cmakedefine01 CONFIG_MPEGTSRAW_DEMUXER
#cmakedefine01 CONFIG_MPEGVIDEO_DEMUXER
#cmakedefine01 CONFIG_MPJPEG_DEMUXER
#cmakedefine01 CONFIG_MPL2_DEMUXER
#cmakedefine01 CONFIG_MPSUB_DEMUXER
#cmakedefine01 CONFIG_MSF_DEMUXER
#cmakedefine01 CONFIG_MSNWC_TCP_DEMUXER
#cmakedefine01 CONFIG_MSP_DEMUXER
#cmakedefine01 CONFIG_MTAF_DEMUXER
#cmakedefine01 CONFIG_MTV_DEMUXER
#cmakedefine01 CONFIG_MUSX_DEMUXER
#cmakedefine01 CONFIG_MV_DEMUXER
#cmakedefine01 CONFIG_MVI_DEMUXER
#cmakedefine01 CONFIG_MXF_DEMUXER
#cmakedefine01 CONFIG_MXG_DEMUXER
#cmakedefine01 CONFIG_NC_DEMUXER
#cmakedefine01 CONFIG_NISTSPHERE_DEMUXER
#cmakedefine01 CONFIG_NSP_DEMUXER
#cmakedefine01 CONFIG_NSV_DEMUXER
#cmakedefine01 CONFIG_NUT_DEMUXER
#cmakedefine01 CONFIG_NUV_DEMUXER
#cmakedefine01 CONFIG_OBU_DEMUXER
#cmakedefine01 CONFIG_OGG_DEMUXER
#cmakedefine01 CONFIG_OMA_DEMUXER
#cmakedefine01 CONFIG_OSQ_DEMUXER
#cmakedefine01 CONFIG_PAF_DEMUXER
#cmakedefine01 CONFIG_PCM_ALAW_DEMUXER
#cmakedefine01 CONFIG_PCM_MULAW_DEMUXER
#cmakedefine01 CONFIG_PCM_VIDC_DEMUXER
#cmakedefine01 CONFIG_PCM_F64BE_DEMUXER
#cmakedefine01 CONFIG_PCM_F64LE_DEMUXER
#cmakedefine01 CONFIG_PCM_F32BE_DEMUXER
#cmakedefine01 CONFIG_PCM_F32LE_DEMUXER
#cmakedefine01 CONFIG_PCM_S32BE_DEMUXER
#cmakedefine01 CONFIG_PCM_S32LE_DEMUXER
#cmakedefine01 CONFIG_PCM_S24BE_DEMUXER
#cmakedefine01 CONFIG_PCM_S24LE_DEMUXER
#cmakedefine01 CONFIG_PCM_S16BE_DEMUXER
#cmakedefine01 CONFIG_PCM_S16LE_DEMUXER
#cmakedefine01 CONFIG_PCM_S8_DEMUXER
#cmakedefine01 CONFIG_PCM_U32BE_DEMUXER
#cmakedefine01 CONFIG_PCM_U32LE_DEMUXER
#cmakedefine01 CONFIG_PCM_U24BE_DEMUXER
#cmakedefine01 CONFIG_PCM_U24LE_DEMUXER
#cmakedefine01 CONFIG_PCM_U16BE_DEMUXER
#cmakedefine01 CONFIG_PCM_U16LE_DEMUXER
#cmakedefine01 CONFIG_PCM_U8_DEMUXER
#cmakedefine01 CONFIG_PDV_DEMUXER
#cmakedefine01 CONFIG_PJS_DEMUXER
#cmakedefine01 CONFIG_PMP_DEMUXER
#cmakedefine01 CONFIG_PP_BNK_DEMUXER
#cmakedefine01 CONFIG_PVA_DEMUXER
#cmakedefine01 CONFIG_PVF_DEMUXER
#cmakedefine01 CONFIG_QCP_DEMUXER
#cmakedefine01 CONFIG_QOA_DEMUXER
#cmakedefine01 CONFIG_R3D_DEMUXER
#cmakedefine01 CONFIG_RAWVIDEO_DEMUXER
#cmakedefine01 CONFIG_REALTEXT_DEMUXER
#cmakedefine01 CONFIG_REDSPARK_DEMUXER
#cmakedefine01 CONFIG_RKA_DEMUXER
#cmakedefine01 CONFIG_RL2_DEMUXER
#cmakedefine01 CONFIG_RM_DEMUXER
#cmakedefine01 CONFIG_ROQ_DEMUXER
#cmakedefine01 CONFIG_RPL_DEMUXER
#cmakedefine01 CONFIG_RSD_DEMUXER
#cmakedefine01 CONFIG_RSO_DEMUXER
#cmakedefine01 CONFIG_RTP_DEMUXER
#cmakedefine01 CONFIG_RTSP_DEMUXER
#cmakedefine01 CONFIG_S337M_DEMUXER
#cmakedefine01 CONFIG_SAMI_DEMUXER
#cmakedefine01 CONFIG_SAP_DEMUXER
#cmakedefine01 CONFIG_SBC_DEMUXER
#cmakedefine01 CONFIG_SBG_DEMUXER
#cmakedefine01 CONFIG_SCC_DEMUXER
#cmakedefine01 CONFIG_SCD_DEMUXER
#cmakedefine01 CONFIG_SDNS_DEMUXER
#cmakedefine01 CONFIG_SDP_DEMUXER
#cmakedefine01 CONFIG_SDR2_DEMUXER
#cmakedefine01 CONFIG_SDS_DEMUXER
#cmakedefine01 CONFIG_SDX_DEMUXER
#cmakedefine01 CONFIG_SEGAFILM_DEMUXER
#cmakedefine01 CONFIG_SER_DEMUXER
#cmakedefine01 CONFIG_SGA_DEMUXER
#cmakedefine01 CONFIG_SHORTEN_DEMUXER
#cmakedefine01 CONFIG_SIFF_DEMUXER
#cmakedefine01 CONFIG_SIMBIOSIS_IMX_DEMUXER
#cmakedefine01 CONFIG_SLN_DEMUXER
#cmakedefine01 CONFIG_SMACKER_DEMUXER
#cmakedefine01 CONFIG_SMJPEG_DEMUXER
#cmakedefine01 CONFIG_SMUSH_DEMUXER
#cmakedefine01 CONFIG_SOL_DEMUXER
#cmakedefine01 CONFIG_SOX_DEMUXER
#cmakedefine01 CONFIG_SPDIF_DEMUXER
#cmakedefine01 CONFIG_SRT_DEMUXER
#cmakedefine01 CONFIG_STR_DEMUXER
#cmakedefine01 CONFIG_STL_DEMUXER
#cmakedefine01 CONFIG_SUBVIEWER1_DEMUXER
#cmakedefine01 CONFIG_SUBVIEWER_DEMUXER
#cmakedefine01 CONFIG_SUP_DEMUXER
#cmakedefine01 CONFIG_SVAG_DEMUXER
#cmakedefine01 CONFIG_SVS_DEMUXER
#cmakedefine01 CONFIG_SWF_DEMUXER
#cmakedefine01 CONFIG_TAK_DEMUXER
#cmakedefine01 CONFIG_TEDCAPTIONS_DEMUXER
#cmakedefine01 CONFIG_THP_DEMUXER
#cmakedefine01 CONFIG_THREEDOSTR_DEMUXER
#cmakedefine01 CONFIG_TIERTEXSEQ_DEMUXER
#cmakedefine01 CONFIG_TMV_DEMUXER
#cmakedefine01 CONFIG_TRUEHD_DEMUXER
#cmakedefine01 CONFIG_TTA_DEMUXER
#cmakedefine01 CONFIG_TXD_DEMUXER
#cmakedefine01 CONFIG_TTY_DEMUXER
#cmakedefine01 CONFIG_TY_DEMUXER
#cmakedefine01 CONFIG_USM_DEMUXER
#cmakedefine01 CONFIG_V210_DEMUXER
#cmakedefine01 CONFIG_V210X_DEMUXER
#cmakedefine01 CONFIG_VAG_DEMUXER
#cmakedefine01 CONFIG_VC1_DEMUXER
#cmakedefine01 CONFIG_VC1T_DEMUXER
#cmakedefine01 CONFIG_VIVIDAS_DEMUXER
#cmakedefine01 CONFIG_VIVO_DEMUXER
#cmakedefine01 CONFIG_VMD_DEMUXER
#cmakedefine01 CONFIG_VOBSUB_DEMUXER
#cmakedefine01 CONFIG_VOC_DEMUXER
#cmakedefine01 CONFIG_VPK_DEMUXER
#cmakedefine01 CONFIG_VPLAYER_DEMUXER
#cmakedefine01 CONFIG_VQF_DEMUXER
#cmakedefine01 CONFIG_VVC_DEMUXER
#cmakedefine01 CONFIG_W64_DEMUXER
#cmakedefine01 CONFIG_WADY_DEMUXER
#cmakedefine01 CONFIG_WAVARC_DEMUXER
#cmakedefine01 CONFIG_WAV_DEMUXER
#cmakedefine01 CONFIG_WC3_DEMUXER
#cmakedefine01 CONFIG_WEBM_DASH_MANIFEST_DEMUXER
#cmakedefine01 CONFIG_WEBVTT_DEMUXER
#cmakedefine01 CONFIG_WSAUD_DEMUXER
#cmakedefine01 CONFIG_WSD_DEMUXER
#cmakedefine01 CONFIG_WSVQA_DEMUXER
#cmakedefine01 CONFIG_WTV_DEMUXER
#cmakedefine01 CONFIG_WVE_DEMUXER
#cmakedefine01 CONFIG_WV_DEMUXER
#cmakedefine01 CONFIG_XA_DEMUXER
#cmakedefine01 CONFIG_XBIN_DEMUXER
#cmakedefine01 CONFIG_XMD_DEMUXER
#cmakedefine01 CONFIG_XMV_DEMUXER
#cmakedefine01 CONFIG_XVAG_DEMUXER
#cmakedefine01 CONFIG_XWMA_DEMUXER
#cmakedefine01 CONFIG_YOP_DEMUXER
#cmakedefine01 CONFIG_YUV4MPEGPIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_BMP_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_CRI_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_DDS_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_DPX_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_EXR_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_GEM_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_GIF_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_HDR_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_J2K_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_JPEG_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_JPEGLS_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_JPEGXL_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PAM_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PBM_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PCX_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PFM_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PGMYUV_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PGM_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PGX_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PHM_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PHOTOCD_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PICTOR_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PNG_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PPM_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_PSD_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_QDRAW_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_QOI_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_SGI_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_SVG_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_SUNRAST_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_TIFF_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_VBN_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_WEBP_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_XBM_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_XPM_PIPE_DEMUXER
#cmakedefine01 CONFIG_IMAGE_XWD_PIPE_DEMUXER
#cmakedefine01 CONFIG_LIBGME_DEMUXER
#cmakedefine01 CONFIG_LIBMODPLUG_DEMUXER
#cmakedefine01 CONFIG_LIBOPENMPT_DEMUXER
#cmakedefine01 CONFIG_VAPOURSYNTH_DEMUXER
#cmakedefine01 CONFIG_A64_MUXER
#cmakedefine01 CONFIG_AC3_MUXER
#cmakedefine01 CONFIG_AC4_MUXER
#cmakedefine01 CONFIG_ADTS_MUXER
#cmakedefine01 CONFIG_ADX_MUXER
#cmakedefine01 CONFIG_AEA_MUXER
#cmakedefine01 CONFIG_AIFF_MUXER
#cmakedefine01 CONFIG_ALP_MUXER
#cmakedefine01 CONFIG_AMR_MUXER
#cmakedefine01 CONFIG_AMV_MUXER
#cmakedefine01 CONFIG_APM_MUXER
#cmakedefine01 CONFIG_APNG_MUXER
#cmakedefine01 CONFIG_APTX_MUXER
#cmakedefine01 CONFIG_APTX_HD_MUXER
#cmakedefine01 CONFIG_ARGO_ASF_MUXER
#cmakedefine01 CONFIG_ARGO_CVG_MUXER
#cmakedefine01 CONFIG_ASF_MUXER
#cmakedefine01 CONFIG_ASS_MUXER
#cmakedefine01 CONFIG_AST_MUXER
#cmakedefine01 CONFIG_ASF_STREAM_MUXER
#cmakedefine01 CONFIG_AU_MUXER
#cmakedefine01 CONFIG_AVI_MUXER
#cmakedefine01 CONFIG_AVIF_MUXER
#cmakedefine01 CONFIG_AVM2_MUXER
#cmakedefine01 CONFIG_AVS2_MUXER
#cmakedefine01 CONFIG_AVS3_MUXER
#cmakedefine01 CONFIG_BIT_MUXER
#cmakedefine01 CONFIG_CAF_MUXER
#cmakedefine01 CONFIG_CAVSVIDEO_MUXER
#cmakedefine01 CONFIG_CODEC2_MUXER
#cmakedefine01 CONFIG_CODEC2RAW_MUXER
#cmakedefine01 CONFIG_CRC_MUXER
#cmakedefine01 CONFIG_DASH_MUXER
#cmakedefine01 CONFIG_DATA_MUXER
#cmakedefine01 CONFIG_DAUD_MUXER
#cmakedefine01 CONFIG_DFPWM_MUXER
#cmakedefine01 CONFIG_DIRAC_MUXER
#cmakedefine01 CONFIG_DNXHD_MUXER
#cmakedefine01 CONFIG_DTS_MUXER
#cmakedefine01 CONFIG_DV_MUXER
#cmakedefine01 CONFIG_EAC3_MUXER
#cmakedefine01 CONFIG_EVC_MUXER
#cmakedefine01 CONFIG_F4V_MUXER
#cmakedefine01 CONFIG_FFMETADATA_MUXER
#cmakedefine01 CONFIG_FIFO_MUXER
#cmakedefine01 CONFIG_FILMSTRIP_MUXER
#cmakedefine01 CONFIG_FITS_MUXER
#cmakedefine01 CONFIG_FLAC_MUXER
#cmakedefine01 CONFIG_FLV_MUXER
#cmakedefine01 CONFIG_FRAMECRC_MUXER
#cmakedefine01 CONFIG_FRAMEHASH_MUXER
#cmakedefine01 CONFIG_FRAMEMD5_MUXER
#cmakedefine01 CONFIG_G722_MUXER
#cmakedefine01 CONFIG_G723_1_MUXER
#cmakedefine01 CONFIG_G726_MUXER
#cmakedefine01 CONFIG_G726LE_MUXER
#cmakedefine01 CONFIG_GIF_MUXER
#cmakedefine01 CONFIG_GSM_MUXER
#cmakedefine01 CONFIG_GXF_MUXER
#cmakedefine01 CONFIG_H261_MUXER
#cmakedefine01 CONFIG_H263_MUXER
#cmakedefine01 CONFIG_H264_MUXER
#cmakedefine01 CONFIG_HASH_MUXER
#cmakedefine01 CONFIG_HDS_MUXER
#cmakedefine01 CONFIG_HEVC_MUXER
#cmakedefine01 CONFIG_HLS_MUXER
#cmakedefine01 CONFIG_IAMF_MUXER
#cmakedefine01 CONFIG_ICO_MUXER
#cmakedefine01 CONFIG_ILBC_MUXER
#cmakedefine01 CONFIG_IMAGE2_MUXER
#cmakedefine01 CONFIG_IMAGE2PIPE_MUXER
#cmakedefine01 CONFIG_IPOD_MUXER
#cmakedefine01 CONFIG_IRCAM_MUXER
#cmakedefine01 CONFIG_ISMV_MUXER
#cmakedefine01 CONFIG_IVF_MUXER
#cmakedefine01 CONFIG_JACOSUB_MUXER
#cmakedefine01 CONFIG_KVAG_MUXER
#cmakedefine01 CONFIG_LATM_MUXER
#cmakedefine01 CONFIG_LRC_MUXER
#cmakedefine01 CONFIG_M4V_MUXER
#cmakedefine01 CONFIG_MD5_MUXER
#cmakedefine01 CONFIG_MATROSKA_MUXER
#cmakedefine01 CONFIG_MATROSKA_AUDIO_MUXER
#cmakedefine01 CONFIG_MICRODVD_MUXER
#cmakedefine01 CONFIG_MJPEG_MUXER
#cmakedefine01 CONFIG_MLP_MUXER
#cmakedefine01 CONFIG_MMF_MUXER
#cmakedefine01 CONFIG_MOV_MUXER
#cmakedefine01 CONFIG_MP2_MUXER
#cmakedefine01 CONFIG_MP3_MUXER
#cmakedefine01 CONFIG_MP4_MUXER
#cmakedefine01 CONFIG_MPEG1SYSTEM_MUXER
#cmakedefine01 CONFIG_MPEG1VCD_MUXER
#cmakedefine01 CONFIG_MPEG1VIDEO_MUXER
#cmakedefine01 CONFIG_MPEG2DVD_MUXER
#cmakedefine01 CONFIG_MPEG2SVCD_MUXER
#cmakedefine01 CONFIG_MPEG2VIDEO_MUXER
#cmakedefine01 CONFIG_MPEG2VOB_MUXER
#cmakedefine01 CONFIG_MPEGTS_MUXER
#cmakedefine01 CONFIG_MPJPEG_MUXER
#cmakedefine01 CONFIG_MXF_MUXER
#cmakedefine01 CONFIG_MXF_D10_MUXER
#cmakedefine01 CONFIG_MXF_OPATOM_MUXER
#cmakedefine01 CONFIG_NULL_MUXER
#cmakedefine01 CONFIG_NUT_MUXER
#cmakedefine01 CONFIG_OBU_MUXER
#cmakedefine01 CONFIG_OGA_MUXER
#cmakedefine01 CONFIG_OGG_MUXER
#cmakedefine01 CONFIG_OGV_MUXER
#cmakedefine01 CONFIG_OMA_MUXER
#cmakedefine01 CONFIG_OPUS_MUXER
#cmakedefine01 CONFIG_PCM_ALAW_MUXER
#cmakedefine01 CONFIG_PCM_MULAW_MUXER
#cmakedefine01 CONFIG_PCM_VIDC_MUXER
#cmakedefine01 CONFIG_PCM_F64BE_MUXER
#cmakedefine01 CONFIG_PCM_F64LE_MUXER
#cmakedefine01 CONFIG_PCM_F32BE_MUXER
#cmakedefine01 CONFIG_PCM_F32LE_MUXER
#cmakedefine01 CONFIG_PCM_S32BE_MUXER
#cmakedefine01 CONFIG_PCM_S32LE_MUXER
#cmakedefine01 CONFIG_PCM_S24BE_MUXER
#cmakedefine01 CONFIG_PCM_S24LE_MUXER
#cmakedefine01 CONFIG_PCM_S16BE_MUXER
#cmakedefine01 CONFIG_PCM_S16LE_MUXER
#cmakedefine01 CONFIG_PCM_S8_MUXER
#cmakedefine01 CONFIG_PCM_U32BE_MUXER
#cmakedefine01 CONFIG_PCM_U32LE_MUXER
#cmakedefine01 CONFIG_PCM_U24BE_MUXER
#cmakedefine01 CONFIG_PCM_U24LE_MUXER
#cmakedefine01 CONFIG_PCM_U16BE_MUXER
#cmakedefine01 CONFIG_PCM_U16LE_MUXER
#cmakedefine01 CONFIG_PCM_U8_MUXER
#cmakedefine01 CONFIG_PSP_MUXER
#cmakedefine01 CONFIG_RAWVIDEO_MUXER
#cmakedefine01 CONFIG_RCWT_MUXER
#cmakedefine01 CONFIG_RM_MUXER
#cmakedefine01 CONFIG_ROQ_MUXER
#cmakedefine01 CONFIG_RSO_MUXER
#cmakedefine01 CONFIG_RTP_MUXER
#cmakedefine01 CONFIG_RTP_MPEGTS_MUXER
#cmakedefine01 CONFIG_RTSP_MUXER
#cmakedefine01 CONFIG_SAP_MUXER
#cmakedefine01 CONFIG_SBC_MUXER
#cmakedefine01 CONFIG_SCC_MUXER
#cmakedefine01 CONFIG_SEGAFILM_MUXER
#cmakedefine01 CONFIG_SEGMENT_MUXER
#cmakedefine01 CONFIG_STREAM_SEGMENT_MUXER
#cmakedefine01 CONFIG_SMJPEG_MUXER
#cmakedefine01 CONFIG_SMOOTHSTREAMING_MUXER
#cmakedefine01 CONFIG_SOX_MUXER
#cmakedefine01 CONFIG_SPX_MUXER
#cmakedefine01 CONFIG_SPDIF_MUXER
#cmakedefine01 CONFIG_SRT_MUXER
#cmakedefine01 CONFIG_STREAMHASH_MUXER
#cmakedefine01 CONFIG_SUP_MUXER
#cmakedefine01 CONFIG_SWF_MUXER
#cmakedefine01 CONFIG_TEE_MUXER
#cmakedefine01 CONFIG_TG2_MUXER
#cmakedefine01 CONFIG_TGP_MUXER
#cmakedefine01 CONFIG_MKVTIMESTAMP_V2_MUXER
#cmakedefine01 CONFIG_TRUEHD_MUXER
#cmakedefine01 CONFIG_TTA_MUXER
#cmakedefine01 CONFIG_TTML_MUXER
#cmakedefine01 CONFIG_UNCODEDFRAMECRC_MUXER
#cmakedefine01 CONFIG_VC1_MUXER
#cmakedefine01 CONFIG_VC1T_MUXER
#cmakedefine01 CONFIG_VOC_MUXER
#cmakedefine01 CONFIG_VVC_MUXER
#cmakedefine01 CONFIG_W64_MUXER
#cmakedefine01 CONFIG_WAV_MUXER
#cmakedefine01 CONFIG_WEBM_MUXER
#cmakedefine01 CONFIG_WEBM_DASH_MANIFEST_MUXER
#cmakedefine01 CONFIG_WEBM_CHUNK_MUXER
#cmakedefine01 CONFIG_WEBP_MUXER
#cmakedefine01 CONFIG_WEBVTT_MUXER
#cmakedefine01 CONFIG_WSAUD_MUXER
#cmakedefine01 CONFIG_WTV_MUXER
#cmakedefine01 CONFIG_WV_MUXER
#cmakedefine01 CONFIG_YUV4MPEGPIPE_MUXER
#cmakedefine01 CONFIG_CHROMAPRINT_MUXER
#cmakedefine01 CONFIG_ANDROID_CONTENT_PROTOCOL
#cmakedefine01 CONFIG_ASYNC_PROTOCOL
#cmakedefine01 CONFIG_BLURAY_PROTOCOL
#cmakedefine01 CONFIG_CACHE_PROTOCOL
#cmakedefine01 CONFIG_CONCAT_PROTOCOL
#cmakedefine01 CONFIG_CONCATF_PROTOCOL
#cmakedefine01 CONFIG_CRYPTO_PROTOCOL
#cmakedefine01 CONFIG_DATA_PROTOCOL
#cmakedefine01 CONFIG_FD_PROTOCOL
#cmakedefine01 CONFIG_FFRTMPCRYPT_PROTOCOL
#cmakedefine01 CONFIG_FFRTMPHTTP_PROTOCOL
#cmakedefine01 CONFIG_FILE_PROTOCOL
#cmakedefine01 CONFIG_FTP_PROTOCOL
#cmakedefine01 CONFIG_GOPHER_PROTOCOL
#cmakedefine01 CONFIG_GOPHERS_PROTOCOL
#cmakedefine01 CONFIG_HLS_PROTOCOL
#cmakedefine01 CONFIG_HTTP_PROTOCOL
#cmakedefine01 CONFIG_HTTPPROXY_PROTOCOL
#cmakedefine01 CONFIG_HTTPS_PROTOCOL
#cmakedefine01 CONFIG_ICECAST_PROTOCOL
#cmakedefine01 CONFIG_MMSH_PROTOCOL
#cmakedefine01 CONFIG_MMST_PROTOCOL
#cmakedefine01 CONFIG_MD5_PROTOCOL
#cmakedefine01 CONFIG_PIPE_PROTOCOL
#cmakedefine01 CONFIG_PROMPEG_PROTOCOL
#cmakedefine01 CONFIG_RTMP_PROTOCOL
#cmakedefine01 CONFIG_RTMPE_PROTOCOL
#cmakedefine01 CONFIG_RTMPS_PROTOCOL
#cmakedefine01 CONFIG_RTMPT_PROTOCOL
#cmakedefine01 CONFIG_RTMPTE_PROTOCOL
#cmakedefine01 CONFIG_RTMPTS_PROTOCOL
#cmakedefine01 CONFIG_RTP_PROTOCOL
#cmakedefine01 CONFIG_SCTP_PROTOCOL
#cmakedefine01 CONFIG_SRTP_PROTOCOL
#cmakedefine01 CONFIG_SUBFILE_PROTOCOL
#cmakedefine01 CONFIG_TEE_PROTOCOL
#cmakedefine01 CONFIG_TCP_PROTOCOL
#cmakedefine01 CONFIG_TLS_PROTOCOL
#cmakedefine01 CONFIG_UDP_PROTOCOL
#cmakedefine01 CONFIG_UDPLITE_PROTOCOL
#cmakedefine01 CONFIG_UNIX_PROTOCOL
#cmakedefine01 CONFIG_LIBAMQP_PROTOCOL
#cmakedefine01 CONFIG_LIBRIST_PROTOCOL
#cmakedefine01 CONFIG_LIBRTMP_PROTOCOL
#cmakedefine01 CONFIG_LIBRTMPE_PROTOCOL
#cmakedefine01 CONFIG_LIBRTMPS_PROTOCOL
#cmakedefine01 CONFIG_LIBRTMPT_PROTOCOL
#cmakedefine01 CONFIG_LIBRTMPTE_PROTOCOL
#cmakedefine01 CONFIG_LIBSRT_PROTOCOL
#cmakedefine01 CONFIG_LIBSSH_PROTOCOL
#cmakedefine01 CONFIG_LIBSMBCLIENT_PROTOCOL
#cmakedefine01 CONFIG_LIBZMQ_PROTOCOL
#cmakedefine01 CONFIG_IPFS_GATEWAY_PROTOCOL
#cmakedefine01 CONFIG_IPNS_GATEWAY_PROTOCOL

#endif
